/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class TransactionalReferenceArray_atomicCompareAndSetTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void whenIndexTooBig_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        array.atomicCompareAndSet(10, (Object)"foo", (Object)"bar");
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void whenIndexTooSmall_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        array.atomicCompareAndSet(-1, (Object)"foo", (Object)"bar");
    }

    @Test
    public void whenExpectedValueFound() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        long version = this.stm.getVersion();
        String update = "foo";
        boolean result = array.atomicCompareAndSet(5, null, (Object)update);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)update, (Object)array.atomicGet(5));
    }

    @Test
    public void whenExpectedValueNotFound() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        long version = this.stm.getVersion();
        boolean result = array.atomicCompareAndSet(5, (Object)"banana", (Object)"foo");
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)array.atomicGet(5));
    }

    @Test
    public void whenActiveTransactionAvailable_thenIgnored() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        Transaction tx = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        long version = this.stm.getVersion();
        boolean result = array.atomicCompareAndSet(5, (Object)"banana", (Object)"foo");
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)array.atomicGet(5));
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }
}

