/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class TransactionalReferenceArray_getPerformanceTest {
    public final long transactionCount = 1000000000L;
    public final int itemCount = 1000;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testTransactionalReferenceArray() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(1000);
        long startNs = System.nanoTime();
        for (long k = 0L; k < 1000000000L; ++k) {
            array.get((int)k % 1000);
            if (k % 100000000L != 0L) continue;
            System.out.println("at: " + k);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0E9 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }

    @Test
    public void testTransactionalReferenceArrayUsingAtomicGet() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(1000);
        long startNs = System.nanoTime();
        for (long k = 0L; k < 1000000000L; ++k) {
            array.atomicGet((int)k % 1000);
            if (k % 100000000L != 0L) continue;
            System.out.println("at: " + k);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0E9 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }

    @Test
    public void testAtomicReferenceArray() {
        AtomicReferenceArray array = new AtomicReferenceArray(1000);
        long startNs = System.nanoTime();
        for (long k = 0L; k < 1000000000L; ++k) {
            array.get((int)k % 1000);
            if (k % 100000000L != 0L) continue;
            System.out.println("at: " + k);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0E9 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }
}

