/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_addAll1Test {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenCollectionNull_thenNullPointerException() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        try {
            list.addAll(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCollectionEmpty() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        boolean result = list.addAll(new LinkedList());
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((Object)"[]", (Object)list.toString());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenMultipleItems() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"1");
        list.add((Object)"2");
        LinkedList<String> c = new LinkedList<String>();
        c.add("3");
        c.add("4");
        c.add("5");
        long version = this.stm.getVersion();
        boolean result = list.addAll(c);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)list.toString());
    }
}

