/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_addTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenEmpty() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        boolean result = list.add((Object)"foo");
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"foo", (Object)list.get(0));
    }

    @Test
    public void whenNotEmpty() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"one");
        long version = this.stm.getVersion();
        boolean result = list.add((Object)"bar");
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"bar", (Object)list.get(1));
    }

    @Test
    public void whenCapacityExceeded() {
        TransactionalArrayList list = new TransactionalArrayList(3);
        list.add((Object)"one");
        list.add((Object)"two");
        list.add((Object)"three");
        long version = this.stm.getVersion();
        list.add((Object)"four");
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[one, two, three, four]", (Object)list.toString());
    }

    @Test
    public void complexScenario() {
        int k;
        TransactionalArrayList list = new TransactionalArrayList();
        for (k = 0; k < 100000; ++k) {
            list.add((Object)k);
        }
        for (k = 0; k < 100000; ++k) {
            Assert.assertEquals((long)k, (long)((Integer)list.get(k)).intValue());
        }
    }
}

