/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_lastIndexOfTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenElementNotAvailble_thenMinesOneReturned() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        int result = list.lastIndexOf((Object)"4");
        Assert.assertEquals((long)-1L, (long)result);
    }

    @Test
    public void whenElementNull() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add(null);
        list.add((Object)"4");
        int result = list.lastIndexOf(null);
        Assert.assertEquals((long)2L, (long)result);
    }

    @Test
    public void whenMultipleOccurrencesLastElementReturned() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        list.add((Object)"2");
        list.add((Object)"5");
        int result = list.lastIndexOf((Object)"2");
        Assert.assertEquals((long)3L, (long)result);
    }
}

