/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_set2Test {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenIndexTooSmall_thenIndexOutOfBoundsException() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        try {
            list.set(-1, (Object)"foo");
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenIndexTooBig_thenIndexOutOfBoundsException() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"a");
        list.add((Object)"b");
        list.add((Object)"c");
        long version = this.stm.getVersion();
        try {
            list.set(3, (Object)"foo");
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenItemWasNull_replaceSuccess() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"a");
        list.add(null);
        list.add((Object)"c");
        long version = this.stm.getVersion();
        String returned = (String)list.set(1, (Object)"b");
        Assert.assertEquals((Object)returned, null);
        Assert.assertEquals((Object)"b", (Object)list.get(1));
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
    }

    @Test
    public void whenItemReplacedByNull_replaceSuccess() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"a");
        list.add((Object)"b");
        list.add((Object)"c");
        long version = this.stm.getVersion();
        String returned = (String)list.set(1, null);
        Assert.assertEquals((Object)returned, (Object)"b");
        Assert.assertEquals(null, (Object)list.get(1));
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
    }

    @Test
    public void whenItemReplaced() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"a");
        list.add((Object)"b");
        list.add((Object)"c");
        long version = this.stm.getVersion();
        String returned = (String)list.set(1, (Object)"newb");
        Assert.assertEquals((Object)returned, (Object)"b");
        Assert.assertEquals((Object)"newb", (Object)list.get(1));
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
    }
}

