/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_addFirstTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void addFirstWithNullFails() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        try {
            list.addFirst(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void addFirstOnEmptyDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        list.addFirst((Object)"1");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }

    @Test
    public void addFirstOnNonEmptyDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.addFirst((Object)"1");
        long version = this.stm.getVersion();
        list.addFirst((Object)"2");
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"[2, 1]", (Object)list.toString());
    }

    @Test
    public void addFirstWithFullDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList(1);
        list.addFirst((Object)"1");
        long version = this.stm.getVersion();
        try {
            list.addFirst((Object)"2");
            Assert.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }
}

