/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_constructorTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testNoArgConstructor() {
        long version = this.stm.getVersion();
        TransactionalLinkedList list = new TransactionalLinkedList();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertFalse((boolean)list.hasRelaxedMaxCapacity());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)list.getMaxCapacity());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void constructorWithNegativeMaxCapacity() {
        long version = this.stm.getVersion();
        try {
            new TransactionalLinkedList(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void constructorWithArray() {
        long version = this.stm.getVersion();
        TransactionalLinkedList list = new TransactionalLinkedList((Object[])new String[]{"1", "2"});
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"1", (Object)list.get(0));
        Assert.assertEquals((Object)"2", (Object)list.get(1));
        Assert.assertFalse((boolean)list.hasRelaxedMaxCapacity());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)list.getMaxCapacity());
    }

    @Test
    public void constructorWithMaxCapacity() {
        long version = this.stm.getVersion();
        TransactionalLinkedList list = new TransactionalLinkedList(10);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)list.getMaxCapacity());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
        Assert.assertFalse((boolean)list.hasRelaxedMaxCapacity());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void constructorWithRelaxedMaxCapacity() {
        long version = this.stm.getVersion();
        TransactionalLinkedList list = new TransactionalLinkedList(100, true);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)100L, (long)list.getMaxCapacity());
        Assert.assertTrue((boolean)list.hasRelaxedMaxCapacity());
        Assert.assertEquals((long)0L, (long)list.size());
    }
}

