/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_drainToTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void drainToWithEmptyDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        TransactionalLinkedList c = new TransactionalLinkedList();
        int result = list.drainTo((Collection)c);
        Assert.assertEquals((long)0L, (long)result);
        Assert.assertTrue((boolean)c.isEmpty());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void drainToWithNonEmptyDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        TransactionalLinkedList c = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        int result = list.drainTo((Collection)c);
        Assert.assertEquals((long)3L, (long)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1, 2, 3]", (Object)c.toString());
        Assert.assertEquals((long)0L, (long)list.size());
    }
}

