/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_takeFirstTest {
    private Stm stm;
    private TransactionFactory updateTxFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.updateTxFactory = this.stm.getTransactionFactoryBuilder().build();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void whenNoItemsRetryErrorIsThrown() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        Transaction t = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        try {
            list.take();
            Assert.fail();
        }
        catch (Retry expected) {
            // empty catch block
        }
        t.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void whenSutIsSingletonSutBecomesEmpty() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        long version = this.stm.getVersion();
        String result = (String)list.takeFirst();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"1", (Object)result);
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void whenSutContainsMoreMultipleItemsFirstIsRemoved() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        long version = this.stm.getVersion();
        String result = (String)list.takeFirst();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"1", (Object)result);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"[2]", (Object)list.toString());
    }
}

