/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.primitives.TransactionalByte;

public class TransactionalByteTest {
    @Test
    public void constructorWithNoArg() {
        TransactionalByte ref = new TransactionalByte();
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @Test
    public void constructorWithSingleArg() {
        TransactionalByte ref = new TransactionalByte(10);
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void set() {
        TransactionalByte ref = new TransactionalByte();
        byte old = ref.set((byte)100);
        Assert.assertEquals((long)0L, (long)old);
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testInc() {
        TransactionalByte ref = new TransactionalByte(100);
        Assert.assertEquals((long)101L, (long)ref.inc());
        Assert.assertEquals((long)101L, (long)ref.get());
        Assert.assertEquals((long)111L, (long)ref.inc((byte)10));
        Assert.assertEquals((long)111L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.inc((byte)-11));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testDec() {
        TransactionalByte ref = new TransactionalByte(100);
        Assert.assertEquals((long)99L, (long)ref.dec());
        Assert.assertEquals((long)99L, (long)ref.get());
        Assert.assertEquals((long)89L, (long)ref.dec((byte)10));
        Assert.assertEquals((long)89L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.dec((byte)-11));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testEquals() {
        TransactionalByte ref1 = new TransactionalByte(10);
        TransactionalByte ref2 = new TransactionalByte(10);
        TransactionalByte ref3 = new TransactionalByte(20);
        Assert.assertFalse((boolean)ref1.equals(null));
        Assert.assertFalse((boolean)ref1.equals((Object)""));
        Assert.assertTrue((boolean)ref1.equals((Object)ref2));
        Assert.assertTrue((boolean)ref2.equals((Object)ref1));
        Assert.assertTrue((boolean)ref1.equals((Object)ref1));
        Assert.assertFalse((boolean)ref1.equals((Object)ref3));
        Assert.assertFalse((boolean)ref3.equals((Object)ref1));
    }

    @Test
    public void testHashCode() {
        TransactionalByte ref = new TransactionalByte(10);
        Assert.assertEquals((long)10L, (long)ref.hashCode());
        ref.set((byte)50);
        Assert.assertEquals((long)50L, (long)ref.hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"TransactionalByte(value=10)", (Object)new TransactionalByte(10).toString());
    }

    @Test
    public void testAtomic() {
        TransactionalByte ref1 = new TransactionalByte(10);
        TransactionalByte ref2 = new TransactionalByte(20);
        try {
            this.incButAbort(ref1, ref2);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)ref1.get());
        Assert.assertEquals((long)20L, (long)ref2.get());
    }

    @TransactionalMethod
    public void incButAbort(TransactionalByte ... refs) {
        for (TransactionalByte ref : refs) {
            ref.inc();
        }
        ThreadLocalTransaction.getThreadLocalTransaction().abort();
    }

    @Test
    public void awaitTest() {
        final TransactionalByte ref = new TransactionalByte();
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                ref.await((byte)2);
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        ref.set((byte)1);
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        ref.set((byte)2);
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }
}

