/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.primitives.TransactionalCharacter;

public class TransactionalCharacterTest {
    @Test
    public void constructorWithNoArg() {
        TransactionalCharacter ref = new TransactionalCharacter();
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @Test
    public void constructorWithSingleArg() {
        TransactionalCharacter ref = new TransactionalCharacter('\n');
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void set() {
        TransactionalCharacter ref = new TransactionalCharacter('\n');
        long old = ref.set('d');
        Assert.assertEquals((long)10L, (long)old);
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testInc() {
        TransactionalCharacter ref = new TransactionalCharacter('d');
        Assert.assertEquals((long)101L, (long)ref.inc());
        Assert.assertEquals((long)101L, (long)ref.get());
        Assert.assertEquals((long)111L, (long)ref.inc('\n'));
        Assert.assertEquals((long)111L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.inc('\ufff5'));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testDec() {
        TransactionalCharacter ref = new TransactionalCharacter('d');
        Assert.assertEquals((long)99L, (long)ref.dec());
        Assert.assertEquals((long)99L, (long)ref.get());
        Assert.assertEquals((long)89L, (long)ref.dec('\n'));
        Assert.assertEquals((long)89L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.dec('\ufff5'));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testEquals() {
        TransactionalCharacter ref1 = new TransactionalCharacter('\n');
        TransactionalCharacter ref2 = new TransactionalCharacter('\n');
        TransactionalCharacter ref3 = new TransactionalCharacter('\u0014');
        Assert.assertFalse((boolean)ref1.equals(null));
        Assert.assertFalse((boolean)ref1.equals((Object)""));
        Assert.assertTrue((boolean)ref1.equals((Object)ref2));
        Assert.assertTrue((boolean)ref2.equals((Object)ref1));
        Assert.assertTrue((boolean)ref1.equals((Object)ref1));
        Assert.assertFalse((boolean)ref1.equals((Object)ref3));
        Assert.assertFalse((boolean)ref3.equals((Object)ref1));
    }

    @Test
    public void testHashCode() {
        TransactionalCharacter ref = new TransactionalCharacter('\n');
        Assert.assertEquals((long)10L, (long)ref.hashCode());
        ref.set('\u00c8');
        Assert.assertEquals((long)200L, (long)ref.hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"TransactionalCharacter(value=a)", (Object)new TransactionalCharacter('a').toString());
    }

    @Test
    public void testAtomic() {
        TransactionalCharacter ref1 = new TransactionalCharacter('a');
        TransactionalCharacter ref2 = new TransactionalCharacter('b');
        try {
            this.incButAbort(ref1, ref2);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertEquals((long)97L, (long)ref1.get());
        Assert.assertEquals((long)98L, (long)ref2.get());
    }

    @TransactionalMethod
    public void incButAbort(TransactionalCharacter ... refs) {
        for (TransactionalCharacter ref : refs) {
            ref.inc();
        }
        ThreadLocalTransaction.getThreadLocalTransaction().abort();
    }

    @Test
    public void awaitTest() {
        final TransactionalCharacter ref = new TransactionalCharacter('a');
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                ref.await('c');
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        ref.set('b');
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        ref.set('c');
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }
}

