/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.primitives.TransactionalFloat;

public class TransactionalFloatTest {
    @Test
    public void constructorWithNoArg() {
        TransactionalFloat ref = new TransactionalFloat();
        this.assertFloatEquals(0.0f, ref.get());
    }

    public void assertFloatEquals(float expected, float found) {
        Assert.assertEquals((long)Float.floatToIntBits(expected), (long)Float.floatToIntBits(found));
    }

    @Test
    public void constructorWithSingleArg() {
        TransactionalFloat ref = new TransactionalFloat(10.0f);
        this.assertFloatEquals(10.0f, ref.get());
    }

    @Test
    public void set() {
        TransactionalFloat ref = new TransactionalFloat();
        Float old = Float.valueOf(ref.set(100.0f));
        this.assertFloatEquals(0.0f, old.floatValue());
        this.assertFloatEquals(100.0f, ref.get());
    }

    @Test
    public void testInc() {
        TransactionalFloat ref = new TransactionalFloat(100.0f);
        this.assertFloatEquals(101.0f, ref.inc());
        this.assertFloatEquals(101.0f, ref.get());
        this.assertFloatEquals(111.0f, ref.inc(10.0f));
        this.assertFloatEquals(111.0f, ref.get());
        this.assertFloatEquals(100.0f, ref.inc(-11.0f));
        this.assertFloatEquals(100.0f, ref.get());
    }

    @Test
    public void testDec() {
        TransactionalFloat ref = new TransactionalFloat(100.0f);
        this.assertFloatEquals(99.0f, ref.dec());
        this.assertFloatEquals(99.0f, ref.get());
        this.assertFloatEquals(89.0f, ref.dec(10.0f));
        this.assertFloatEquals(89.0f, ref.get());
        this.assertFloatEquals(100.0f, ref.dec(-11.0f));
        this.assertFloatEquals(100.0f, ref.get());
    }

    @Test
    public void testEquals() {
        TransactionalFloat ref1 = new TransactionalFloat(10.0f);
        TransactionalFloat ref2 = new TransactionalFloat(10.0f);
        TransactionalFloat ref3 = new TransactionalFloat(20.0f);
        Assert.assertFalse((boolean)ref1.equals(null));
        Assert.assertFalse((boolean)ref1.equals((Object)""));
        Assert.assertTrue((boolean)ref1.equals((Object)ref2));
        Assert.assertTrue((boolean)ref2.equals((Object)ref1));
        Assert.assertTrue((boolean)ref1.equals((Object)ref1));
        Assert.assertFalse((boolean)ref1.equals((Object)ref3));
        Assert.assertFalse((boolean)ref3.equals((Object)ref1));
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)new Float(100.0f).hashCode(), (long)new TransactionalFloat(100.0f).hashCode());
        Assert.assertEquals((long)new Float(10.0f).hashCode(), (long)new TransactionalFloat(10.0f).hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"TransactionalFloat(value=10.0)", (Object)new TransactionalFloat(10.0f).toString());
    }

    @Test
    public void testAtomic() {
        TransactionalFloat ref1 = new TransactionalFloat(10.0f);
        TransactionalFloat ref2 = new TransactionalFloat(20.0f);
        try {
            this.incButAbort(ref1, ref2);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        this.assertFloatEquals(10.0f, ref1.get());
        this.assertFloatEquals(20.0f, ref2.get());
    }

    @TransactionalMethod
    public void incButAbort(TransactionalFloat ... refs) {
        for (TransactionalFloat ref : refs) {
            ref.inc();
        }
        ThreadLocalTransaction.getThreadLocalTransaction().abort();
    }
}

