/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.primitives.TransactionalShort;

public class TransactionalShortTest {
    @Test
    public void constructorWithNoArg() {
        TransactionalShort ref = new TransactionalShort();
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @Test
    public void constructorWithSingleArg() {
        TransactionalShort ref = new TransactionalShort(10);
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void set() {
        TransactionalShort ref = new TransactionalShort(10);
        long old = ref.set((short)100);
        Assert.assertEquals((long)10L, (long)old);
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testInc() {
        TransactionalShort ref = new TransactionalShort(100);
        Assert.assertEquals((long)101L, (long)ref.inc());
        Assert.assertEquals((long)101L, (long)ref.get());
        Assert.assertEquals((long)111L, (long)ref.inc((short)10));
        Assert.assertEquals((long)111L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.inc((short)-11));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testDec() {
        TransactionalShort ref = new TransactionalShort(100);
        Assert.assertEquals((long)99L, (long)ref.dec());
        Assert.assertEquals((long)99L, (long)ref.get());
        Assert.assertEquals((long)89L, (long)ref.dec((short)10));
        Assert.assertEquals((long)89L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.dec((short)-11));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testEquals() {
        TransactionalShort ref1 = new TransactionalShort(10);
        TransactionalShort ref2 = new TransactionalShort(10);
        TransactionalShort ref3 = new TransactionalShort(20);
        Assert.assertFalse((boolean)ref1.equals(null));
        Assert.assertFalse((boolean)ref1.equals((Object)""));
        Assert.assertTrue((boolean)ref1.equals((Object)ref2));
        Assert.assertTrue((boolean)ref2.equals((Object)ref1));
        Assert.assertTrue((boolean)ref1.equals((Object)ref1));
        Assert.assertFalse((boolean)ref1.equals((Object)ref3));
        Assert.assertFalse((boolean)ref3.equals((Object)ref1));
    }

    @Test
    public void testHashCode() {
        TransactionalShort ref = new TransactionalShort(10);
        Assert.assertEquals((long)10L, (long)ref.hashCode());
        ref.set((short)200);
        Assert.assertEquals((long)200L, (long)ref.hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"TransactionalShort(value=10)", (Object)new TransactionalShort(10).toString());
    }

    @Test
    public void testAtomic() {
        TransactionalShort ref1 = new TransactionalShort(10);
        TransactionalShort ref2 = new TransactionalShort(20);
        try {
            this.incButAbort(ref1, ref2);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)ref1.get());
        Assert.assertEquals((long)20L, (long)ref2.get());
    }

    @TransactionalMethod
    public void incButAbort(TransactionalShort ... refs) {
        for (TransactionalShort ref : refs) {
            ref.inc();
        }
        ThreadLocalTransaction.getThreadLocalTransaction().abort();
    }
}

