/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.primitives.TransactionalLong;

public class TransactionalStressTest {
    @Test
    public void constructorWithNoArg() {
        TransactionalLong ref = new TransactionalLong();
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @Test
    public void constructorWithSingleArg() {
        TransactionalLong ref = new TransactionalLong(10L);
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void set() {
        TransactionalLong ref = new TransactionalLong();
        long old = ref.set(100L);
        Assert.assertEquals((long)0L, (long)old);
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testInc() {
        TransactionalLong ref = new TransactionalLong(100L);
        Assert.assertEquals((long)101L, (long)ref.inc());
        Assert.assertEquals((long)101L, (long)ref.get());
        Assert.assertEquals((long)111L, (long)ref.inc(10L));
        Assert.assertEquals((long)111L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.inc(-11L));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testDec() {
        TransactionalLong ref = new TransactionalLong(100L);
        Assert.assertEquals((long)99L, (long)ref.dec());
        Assert.assertEquals((long)99L, (long)ref.get());
        Assert.assertEquals((long)89L, (long)ref.dec(10L));
        Assert.assertEquals((long)89L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.dec(-11L));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testEquals() {
        TransactionalLong ref1 = new TransactionalLong(10L);
        TransactionalLong ref2 = new TransactionalLong(10L);
        TransactionalLong ref3 = new TransactionalLong(20L);
        Assert.assertFalse((boolean)ref1.equals(null));
        Assert.assertFalse((boolean)ref1.equals((Object)""));
        Assert.assertTrue((boolean)ref1.equals((Object)ref2));
        Assert.assertTrue((boolean)ref2.equals((Object)ref1));
        Assert.assertTrue((boolean)ref1.equals((Object)ref1));
        Assert.assertFalse((boolean)ref1.equals((Object)ref3));
        Assert.assertFalse((boolean)ref3.equals((Object)ref1));
    }

    @Test
    public void testHashCode() {
        TransactionalLong ref = new TransactionalLong(10L);
        Assert.assertEquals((long)new Long(10L).hashCode(), (long)ref.hashCode());
        ref.set(200L);
        Assert.assertEquals((long)new Long(200L).hashCode(), (long)ref.hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"TransactionalLong(value=10)", (Object)new TransactionalLong(10L).toString());
    }

    @Test
    public void testAtomic() {
        TransactionalLong ref1 = new TransactionalLong(10L);
        TransactionalLong ref2 = new TransactionalLong(20L);
        try {
            this.incButAbort(ref1, ref2);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)ref1.get());
        Assert.assertEquals((long)20L, (long)ref2.get());
    }

    @TransactionalMethod
    public void incButAbort(TransactionalLong ... refs) {
        for (TransactionalLong ref : refs) {
            ref.inc();
        }
        ThreadLocalTransaction.getThreadLocalTransaction().abort();
    }
}

