/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.tranlocal;

import java.util.LinkedList;
import java.util.List;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.FieldMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTranlocalSnapshot;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public final class TranlocalSnapshotFactory
implements Opcodes {
    private final ClassNode classNode;
    private final String tranlocalName;
    private final String tranlocalSnapshotName;
    private final MetadataRepository metadataService;
    private final ClassMetadata classMetadata;

    public TranlocalSnapshotFactory(ClassLoader classLoader, ClassNode classNode, MetadataRepository metadataRepository) {
        this.metadataService = metadataRepository;
        this.classNode = classNode;
        this.classMetadata = this.metadataService.loadClassMetadata(classLoader, classNode.name);
        this.tranlocalName = this.classMetadata.getTranlocalName();
        this.tranlocalSnapshotName = this.classMetadata.getTranlocalSnapshotName();
    }

    public ClassNode create() {
        if (!this.classMetadata.hasManagedFields()) {
            return null;
        }
        ClassNode result = new ClassNode();
        result.version = this.classNode.version;
        result.name = this.tranlocalSnapshotName;
        result.superName = Type.getInternalName(AlphaTranlocalSnapshot.class);
        result.access = 4113;
        result.sourceFile = this.classNode.sourceFile;
        result.sourceDebug = this.classNode.sourceDebug;
        result.methods.add(this.createConstructor());
        result.methods.add(this.createRestoreMethod());
        result.methods.add(this.createGetTranlocalMethod());
        result.fields.addAll(this.createFields());
        return result;
    }

    public List<FieldNode> createFields() {
        LinkedList<FieldNode> fields = new LinkedList<FieldNode>();
        FieldNode tranlocalField = new FieldNode(4114, "___tranlocal", AsmUtils.internalToDesc((String)this.tranlocalName), null, null);
        fields.add(tranlocalField);
        for (FieldNode fieldNode : this.classNode.fields) {
            FieldMetadata fieldMetadata = this.classMetadata.getFieldMetadata(fieldNode.name);
            if (!fieldMetadata.isManagedField()) continue;
            FieldNode newFieldNode = new FieldNode(4114, fieldNode.name, fieldNode.desc, fieldNode.signature, null);
            fields.add(newFieldNode);
        }
        return fields;
    }

    public MethodNode createConstructor() {
        MethodNode m = new MethodNode(4097, "<init>", String.format("(%s)V", AsmUtils.internalToDesc((String)this.tranlocalName)), null, new String[0]);
        m.visitVarInsn(25, 0);
        m.visitMethodInsn(183, Type.getInternalName(AlphaTranlocalSnapshot.class), "<init>", "()V");
        m.visitVarInsn(25, 0);
        m.visitVarInsn(25, 1);
        m.visitFieldInsn(181, this.tranlocalSnapshotName, "___tranlocal", AsmUtils.internalToDesc((String)this.tranlocalName));
        for (FieldNode fieldNode : this.classNode.fields) {
            FieldMetadata fieldMetadata = this.classMetadata.getFieldMetadata(fieldNode.name);
            if (!fieldMetadata.isManagedField()) continue;
            m.visitVarInsn(25, 0);
            m.visitVarInsn(25, 1);
            m.visitFieldInsn(180, this.tranlocalName, fieldNode.name, fieldNode.desc);
            m.visitFieldInsn(181, this.tranlocalSnapshotName, fieldNode.name, fieldNode.desc);
        }
        m.visitInsn(177);
        m.visitMaxs(0, 0);
        m.visitEnd();
        return m;
    }

    public MethodNode createGetTranlocalMethod() {
        MethodNode m = new MethodNode(4097, "getTranlocal", String.format("()%s", Type.getDescriptor(AlphaTranlocal.class)), null, new String[0]);
        m.visitVarInsn(25, 0);
        m.visitFieldInsn(180, this.tranlocalSnapshotName, "___tranlocal", AsmUtils.internalToDesc((String)this.tranlocalName));
        m.visitInsn(176);
        m.visitMaxs(0, 0);
        m.visitEnd();
        return m;
    }

    public MethodNode createRestoreMethod() {
        MethodNode m = new MethodNode(4097, "restore", "()V", null, new String[0]);
        for (FieldNode fieldNode : this.classNode.fields) {
            FieldMetadata fieldMetadata = this.classMetadata.getFieldMetadata(fieldNode.name);
            if (!fieldMetadata.isManagedField()) continue;
            m.visitVarInsn(25, 0);
            m.visitFieldInsn(180, this.tranlocalSnapshotName, "___tranlocal", AsmUtils.internalToDesc((String)this.tranlocalName));
            m.visitVarInsn(25, 0);
            m.visitFieldInsn(180, this.tranlocalSnapshotName, fieldNode.name, fieldNode.desc);
            m.visitFieldInsn(181, this.tranlocalName, fieldNode.name, fieldNode.desc);
        }
        m.visitInsn(177);
        m.visitMaxs(0, 0);
        m.visitEnd();
        return m;
    }
}

