/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.mixins;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.multiverse.MultiverseConstants;
import org.multiverse.api.Listeners;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.PanicError;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStmUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.RegisterRetryListenerResult;
import org.multiverse.utils.TodoException;

public abstract class FastTxObjectMixin
implements AlphaTransactionalObject,
MultiverseConstants {
    private static final AtomicReferenceFieldUpdater<FastTxObjectMixin, Transaction> ___LOCKOWNER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FastTxObjectMixin.class, Transaction.class, "___lockOwner");
    private static final AtomicReferenceFieldUpdater<FastTxObjectMixin, AlphaTranlocal> ___TRANLOCAL_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FastTxObjectMixin.class, AlphaTranlocal.class, "___tranlocal");
    private volatile Transaction ___lockOwner;
    private volatile AlphaTranlocal ___tranlocal;

    @Override
    public AlphaTranlocal ___load() {
        return ___TRANLOCAL_UPDATER.get(this);
    }

    public Listeners ___getListeners() {
        return null;
    }

    @Override
    public AlphaTranlocal ___load(long readVersion) {
        boolean otherWritesHaveBeenExecuted;
        if (___LOCKOWNER_UPDATER.get(this) != null) {
            throw LockNotFreeReadConflict.INSTANCE;
        }
        AlphaTranlocal tranlocalTime1 = ___TRANLOCAL_UPDATER.get(this);
        if (tranlocalTime1 == null) {
            return null;
        }
        if (___SANITY_CHECKS_ENABLED && tranlocalTime1.getWriteVersion() <= 0L) {
            throw new PanicError();
        }
        if (tranlocalTime1.getWriteVersion() == readVersion) {
            return tranlocalTime1;
        }
        if (tranlocalTime1.getWriteVersion() > readVersion) {
            if (OldVersionNotFoundReadConflict.reuse) {
                throw OldVersionNotFoundReadConflict.INSTANCE;
            }
            String msg = String.format("Can't load version '%s' for transactionalobject '%s', the oldest version found is '%s'", readVersion, AlphaStmUtils.toTxObjectString(this), tranlocalTime1.getWriteVersion());
            throw new OldVersionNotFoundReadConflict(msg);
        }
        Transaction lockOwner = ___LOCKOWNER_UPDATER.get(this);
        if (lockOwner != null) {
            if (LockNotFreeReadConflict.reuse) {
                throw LockNotFreeReadConflict.INSTANCE;
            }
            String msg = String.format("Failed to load already locked transactionalobject '%s'", AlphaStmUtils.toTxObjectString(this));
            throw new LockNotFreeReadConflict(msg);
        }
        AlphaTranlocal tranlocalTime2 = ___TRANLOCAL_UPDATER.get(this);
        boolean bl = otherWritesHaveBeenExecuted = tranlocalTime2 != tranlocalTime1;
        if (otherWritesHaveBeenExecuted) {
            if (tranlocalTime2.getWriteVersion() == readVersion) {
                return tranlocalTime2;
            }
            if (OldVersionNotFoundReadConflict.reuse) {
                throw OldVersionNotFoundReadConflict.INSTANCE;
            }
            String msg = String.format("Can't load version '%s' transactionalobject '%s', the oldest version found is '%s'", readVersion, AlphaStmUtils.toTxObjectString(this), tranlocalTime2.getWriteVersion());
            throw new OldVersionNotFoundReadConflict(msg);
        }
        return tranlocalTime1;
    }

    @Override
    public AlphaTranlocal ___openForCommutingOperation() {
        throw new TodoException();
    }

    public Transaction ___getLockOwner() {
        return ___LOCKOWNER_UPDATER.get(this);
    }

    public boolean ___tryLock(Transaction lockOwner) {
        return ___LOCKOWNER_UPDATER.compareAndSet(this, null, lockOwner);
    }

    public void ___releaseLock(Transaction expectedLockOwner) {
        ___LOCKOWNER_UPDATER.compareAndSet(this, expectedLockOwner, null);
    }

    @Override
    public void ___storeInitial(AlphaTranlocal tranlocal, long writeVersion) {
        tranlocal.prepareForCommit(writeVersion);
        ___TRANLOCAL_UPDATER.set(this, tranlocal);
    }

    @Override
    public Listeners ___storeUpdate(AlphaTranlocal tranlocal, long writeVersion, boolean releaseLock) {
        assert (tranlocal != null);
        if (___SANITY_CHECKS_ENABLED) {
            if (this.___lockOwner == null) {
                String msg = String.format("Lock on transactionalObject '%s' is not hold while doing the store", AlphaStmUtils.toTxObjectString(this));
                throw new PanicError(msg);
            }
            if (tranlocal.getWriteVersion() >= writeVersion) {
                String msg = String.format("The tranlocal of transactionalObject '%s' has version '%s'  and and is too large for writeVersion '%s'", AlphaStmUtils.toTxObjectString(this), tranlocal.getTransactionalObject(), writeVersion);
                throw new PanicError(msg);
            }
            AlphaTranlocal old = ___TRANLOCAL_UPDATER.get(this);
            if (old != null && old.getWriteVersion() >= writeVersion) {
                String msg = String.format("The current version '%s' is newer than the version '%s' to commit for transactionalobject '%s''", old.getWriteVersion(), writeVersion, tranlocal.getWriteVersion());
                throw new PanicError(msg);
            }
        }
        tranlocal.prepareForCommit(writeVersion);
        ___TRANLOCAL_UPDATER.set(this, tranlocal);
        if (releaseLock) {
            ___LOCKOWNER_UPDATER.set(this, null);
        }
        return null;
    }

    @Override
    public RegisterRetryListenerResult ___registerRetryListener(Latch listener, long minimumWakeupVersion) {
        return RegisterRetryListenerResult.noregistration;
    }
}

