/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.AbstractTransactionSnapshot;
import org.multiverse.stms.alpha.AlphaStmUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.AbstractAlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public abstract class AbstractReadonlyAlphaTransaction
extends AbstractAlphaTransaction<ReadonlyConfiguration, AbstractTransactionSnapshot> {
    public AbstractReadonlyAlphaTransaction(ReadonlyConfiguration config) {
        super(config);
    }

    protected abstract AlphaTranlocal findAttached(AlphaTransactionalObject var1);

    protected abstract void attach(AlphaTranlocal var1);

    @Override
    protected final AlphaTranlocal doOpenForRead(AlphaTransactionalObject txObject) {
        AlphaTranlocal tranlocal = this.findAttached(txObject);
        if (tranlocal == null) {
            tranlocal = this.load(txObject);
            if (tranlocal == null) {
                throw this.createLoadUncommittedException(txObject);
            }
            if (((ReadonlyConfiguration)this.config).readTrackingEnabled) {
                this.attach(tranlocal);
            }
        }
        return tranlocal;
    }

    protected UncommittedReadConflict createLoadUncommittedException(AlphaTransactionalObject txObject) {
        String msg = String.format("Can't open for read transactional object '%s' in transaction '%s' because the readonly transactional object has not been committed before. The cause of this problem is very likely that a reference to this transactional object escaped the creating transaction before that transaction was committed.'", AlphaStmUtils.toTxObjectString(txObject), ((ReadonlyConfiguration)this.config).getFamilyName());
        return new UncommittedReadConflict(msg);
    }

    @Override
    public AlphaTranlocal doOpenForCommutingWrite(AlphaTransactionalObject txObject) {
        return this.doOpenForWrite(txObject);
    }

    @Override
    public AlphaTranlocal doOpenForConstruction(AlphaTransactionalObject txObject) {
        return this.doOpenForWrite(txObject);
    }

    @Override
    protected final AlphaTranlocal doOpenForWrite(AlphaTransactionalObject txObject) {
        SpeculativeConfiguration speculativeConfig = ((ReadonlyConfiguration)this.config).speculativeConfiguration;
        if (speculativeConfig.isSpeculativeReadonlyEnabled()) {
            speculativeConfig.signalSpeculativeReadonlyFailure();
            throw SpeculativeConfigurationFailure.create();
        }
        String msg = String.format("Can't open for write transactional object '%s' because transaction '%s' is readonly'", AlphaStmUtils.toTxObjectString(txObject), ((ReadonlyConfiguration)this.config).getFamilyName());
        throw new ReadonlyException(msg);
    }
}

