/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.multiverse.api.Listeners;
import org.multiverse.api.commitlock.CommitLockFilter;
import org.multiverse.api.exceptions.LockNotFreeWriteConflict;
import org.multiverse.api.exceptions.OptimisticLockFailedWriteConflict;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.api.exceptions.WriteSkewConflict;
import org.multiverse.stms.AbstractTransactionSnapshot;
import org.multiverse.stms.alpha.AlphaStmUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.UncommittedFilter;
import org.multiverse.stms.alpha.transactions.AbstractAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;
import org.multiverse.stms.alpha.transactions.update.UpdateTransactionStatus;

public abstract class AbstractUpdateAlphaTransaction
extends AbstractAlphaTransaction<UpdateConfiguration, AbstractTransactionSnapshot> {
    private long writeVersion;
    protected UpdateTransactionStatus updateTransactionStatus = UpdateTransactionStatus.nowrites;

    public AbstractUpdateAlphaTransaction(UpdateConfiguration config) {
        super(config);
    }

    protected final void doClear() {
        this.updateTransactionStatus = UpdateTransactionStatus.nowrites;
        this.dodoClear();
    }

    protected abstract void dodoClear();

    protected abstract void attach(AlphaTranlocal var1);

    protected abstract AlphaTranlocal findAttached(AlphaTransactionalObject var1);

    @Override
    protected final AlphaTranlocal doOpenForRead(AlphaTransactionalObject txObject) {
        AlphaTranlocal opened = this.findAttached(txObject);
        if (opened != null) {
            if (opened.isCommuting()) {
                AlphaTranlocal origin = this.load(txObject);
                if (origin == null) {
                    throw new UncommittedReadConflict();
                }
                opened.prematureFixation(this, origin);
            }
            return opened;
        }
        opened = this.load(txObject);
        if (opened == null) {
            throw new UncommittedReadConflict();
        }
        if (((UpdateConfiguration)this.config).readTrackingEnabled) {
            this.attach(opened);
        }
        return opened;
    }

    @Override
    protected AlphaTranlocal doOpenForWrite(AlphaTransactionalObject txObject) {
        AlphaTranlocal attached = this.findAttached(txObject);
        if (attached == null) {
            attached = this.doOpenForWritePreviousCommittedAndAttach(txObject);
            this.updateTransactionStatus = this.updateTransactionStatus.upgradeToOpenForWrite();
        } else if (attached.isCommitted()) {
            attached = attached.openForWrite();
            this.attach(attached);
            this.updateTransactionStatus = this.updateTransactionStatus.upgradeToOpenForWrite();
        } else if (attached.isCommuting()) {
            AlphaTranlocal origin = this.load(txObject);
            if (origin == null) {
                throw new UncommittedReadConflict();
            }
            attached.prematureFixation(this, origin);
            this.updateTransactionStatus = this.updateTransactionStatus.upgradeToOpenForWrite();
        }
        return attached;
    }

    protected final AlphaTranlocal doOpenForWritePreviousCommittedAndAttach(AlphaTransactionalObject txObject) {
        AlphaTranlocal committed = txObject.___load(this.getReadVersion());
        if (committed == null) {
            throw new UncommittedReadConflict();
        }
        AlphaTranlocal opened = committed.openForWrite();
        this.attach(opened);
        return opened;
    }

    @Override
    protected AlphaTranlocal doOpenForCommutingWrite(AlphaTransactionalObject txObject) {
        this.updateTransactionStatus = this.updateTransactionStatus.upgradeToOpenForWrite();
        AlphaTranlocal attached = this.findAttached(txObject);
        if (attached == null) {
            attached = txObject.___openForCommutingOperation();
            this.attach(attached);
        } else if (attached.isCommitted()) {
            attached = attached.openForWrite();
            this.attach(attached);
        }
        return attached;
    }

    @Override
    public final AlphaTranlocal doOpenForConstruction(AlphaTransactionalObject txObject) {
        AlphaTranlocal opened = this.findAttached(txObject);
        if (opened != null) {
            if (opened.isCommitted()) {
                String msg = String.format("Can't open for construction transactional object '%s' using transaction '%s'because the transactional object already has commits", AlphaStmUtils.toTxObjectString(txObject), ((UpdateConfiguration)this.config).getFamilyName());
                throw new IllegalStateException(msg);
            }
            if (opened.isCommuting()) {
                String msg = String.format("Can't open for construction transactional object '%s' using transaction '%s'because the transactional object is opened for a commuting operations", AlphaStmUtils.toTxObjectString(txObject), ((UpdateConfiguration)this.config).getFamilyName());
                throw new IllegalStateException(msg);
            }
            if (opened.getOrigin() != null) {
                String msg = String.format("Can't open for construction transactional object '%s' using transaction '%s'because the transactional object already has commits", AlphaStmUtils.toTxObjectString(txObject), ((UpdateConfiguration)this.config).getFamilyName());
                throw new IllegalStateException(msg);
            }
            return opened;
        }
        this.updateTransactionStatus = this.updateTransactionStatus.upgradeToOpenForConstruction();
        AlphaTranlocal fresh = txObject.___openUnconstructed();
        this.attach(fresh);
        return fresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doPrepare() {
        switch (this.updateTransactionStatus) {
            case nowrites: {
                break;
            }
            case newonly: {
                this.writeVersion = ((UpdateConfiguration)this.config).clock.getVersion();
                break;
            }
            case updates: {
                UncommittedFilter commitLockFilter;
                if (!this.isDirty()) {
                    return;
                }
                UncommittedFilter uncommittedFilter = commitLockFilter = ((UpdateConfiguration)this.config).dirtyCheckEnabled ? UncommittedFilter.DIRTY_CHECK : UncommittedFilter.NO_DIRTY_CHECK;
                if (!this.tryWriteLocks(commitLockFilter)) {
                    throw this.createFailedToObtainCommitLocksException();
                }
                boolean failure = true;
                try {
                    if (((UpdateConfiguration)this.config).writeSkewAllowed) {
                        boolean skipConflictDetection;
                        boolean bl = skipConflictDetection = ((UpdateConfiguration)this.config).optimizedConflictDetectionEnabled && this.getReadVersion() == ((UpdateConfiguration)this.config).clock.getVersion();
                        if (!skipConflictDetection && this.hasWriteConflict()) {
                            throw this.createOptimisticLockFailedWriteConflict();
                        }
                        this.writeVersion = ((UpdateConfiguration)this.config).clock.tick();
                    } else {
                        boolean possiblySkipConflictDetection;
                        boolean bl = possiblySkipConflictDetection = ((UpdateConfiguration)this.config).optimizedConflictDetectionEnabled && this.getReadVersion() == ((UpdateConfiguration)this.config).clock.getVersion();
                        if (possiblySkipConflictDetection) {
                            this.writeVersion = ((UpdateConfiguration)this.config).clock.strictTick();
                            if (this.writeVersion != this.getReadVersion() + 1L && this.hasReadConflict()) {
                                throw this.createWriteSkewConflict();
                            }
                        } else {
                            if (this.hasReadConflict()) {
                                throw this.createWriteSkewConflict();
                            }
                            this.writeVersion = ((UpdateConfiguration)this.config).clock.strictTick();
                        }
                    }
                    failure = false;
                    break;
                }
                finally {
                    if (failure) {
                        this.doReleaseWriteLocksForFailure();
                    }
                }
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected abstract boolean isDirty();

    protected final boolean isDirty(AlphaTranlocal attached) {
        if (attached == null) {
            return false;
        }
        if (attached.isCommitted()) {
            return false;
        }
        if (attached.isCommuting()) {
            return true;
        }
        if (!((UpdateConfiguration)this.config).dirtyCheckEnabled) {
            return true;
        }
        return attached.executeDirtyCheck();
    }

    protected abstract boolean hasWriteConflict();

    protected final boolean hasWriteConflict(AlphaTranlocal tranlocal) {
        if (tranlocal == null) {
            return false;
        }
        return tranlocal.hasWriteConflict();
    }

    protected abstract boolean hasReadConflict();

    protected final boolean hasReadConflict(AlphaTranlocal attached) {
        if (attached == null) {
            return false;
        }
        return attached.hasReadConflict(this);
    }

    protected abstract boolean tryWriteLocks(CommitLockFilter var1);

    protected abstract void doReleaseWriteLocksForFailure();

    protected final void doReleaseWriteSetLocksForFailure(AlphaTranlocal tranlocal) {
        boolean release = true;
        if (tranlocal == null) {
            release = false;
        } else if (tranlocal.isCommitted()) {
            release = false;
        } else if (((UpdateConfiguration)this.config).dirtyCheckEnabled && !tranlocal.getPrecalculatedIsDirty()) {
            release = false;
        }
        if (release) {
            AlphaTransactionalObject txObject = tranlocal.getTransactionalObject();
            txObject.___releaseLock(this);
        }
    }

    protected abstract void doReleaseWriteLocksForSuccess(long var1);

    protected final void doReleaseWriteLockForSuccess(AlphaTranlocal tranlocal, long writeVersion) {
        if (tranlocal == null) {
            return;
        }
        boolean release = true;
        if (tranlocal.isCommitted() && tranlocal.___writeVersion != writeVersion) {
            release = false;
        }
        if (release) {
            AlphaTransactionalObject txObject = tranlocal.getTransactionalObject();
            txObject.___releaseLock(this);
        }
    }

    protected abstract Listeners[] makeChangesPermanent(long var1);

    protected final Listeners makePermanent(AlphaTranlocal tranlocal, long writeVersion) {
        if (tranlocal == null) {
            return null;
        }
        if (tranlocal.isCommitted()) {
            return null;
        }
        tranlocal.lateFixation(this);
        AlphaTransactionalObject txObject = tranlocal.getTransactionalObject();
        AlphaTranlocal origin = tranlocal.getOrigin();
        boolean store = false;
        if (!((UpdateConfiguration)this.config).dirtyCheckEnabled) {
            store = true;
        } else if (origin == null) {
            store = true;
        } else if (tranlocal.getPrecalculatedIsDirty()) {
            store = true;
        }
        if (!store) {
            return null;
        }
        if (origin == null) {
            txObject.___storeInitial(tranlocal, writeVersion);
            return null;
        }
        return txObject.___storeUpdate(tranlocal, writeVersion, ((UpdateConfiguration)this.config).quickReleaseLocksEnabled);
    }

    protected void doAbortPrepared() {
        this.doReleaseWriteLocksForFailure();
    }

    protected void makeChangesPermanent() {
        Listeners[] listeners = this.makeChangesPermanent(this.writeVersion);
        if (!((UpdateConfiguration)this.config).quickReleaseLocksEnabled) {
            this.doReleaseWriteLocksForSuccess(this.writeVersion);
        }
        Listeners.openAll((Listeners[])listeners);
    }

    private OptimisticLockFailedWriteConflict createOptimisticLockFailedWriteConflict() {
        if (OptimisticLockFailedWriteConflict.reuse) {
            return OptimisticLockFailedWriteConflict.INSTANCE;
        }
        String msg = String.format("Failed to commit transaction '%s' because there was a write conflict'", ((UpdateConfiguration)this.config).getFamilyName());
        return new OptimisticLockFailedWriteConflict(msg);
    }

    private WriteSkewConflict createWriteSkewConflict() {
        if (WriteSkewConflict.reuse) {
            return WriteSkewConflict.INSTANCE;
        }
        String msg = String.format("Failed to commit transaction '%s' because a writeconflict was detected. The exact problem was a writeskew.", ((UpdateConfiguration)this.config).getFamilyName());
        return new WriteSkewConflict(msg);
    }

    private LockNotFreeWriteConflict createFailedToObtainCommitLocksException() {
        if (LockNotFreeWriteConflict.reuse) {
            return LockNotFreeWriteConflict.INSTANCE;
        }
        String msg = String.format("Failed to commit transaction '%s' because not all the locks on the transactional objects in the writeset could be obtained", ((UpdateConfiguration)this.config).getFamilyName());
        return new LockNotFreeWriteConflict(msg);
    }
}

