/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.benchmarks;

import org.benchy.Benchmark;
import org.benchy.TestCase;
import org.benchy.graph.GraphMain;
import org.benchy.repository.BenchmarkResultRepository;
import org.benchy.repository.FileBasedBenchmarkResultRepository;
import org.benchy.runner.DefaultBenchmarkRunner;
import org.multiverse.benchmarks.ConcurrentUpdateDriver;
import org.multiverse.benchmarks.ConcurrentUpdateWithIntrinsicLockDriver;
import org.multiverse.benchmarks.NonConcurrentUpdateDriver;
import org.multiverse.benchmarks.PropertyAccessorDriver;
import org.multiverse.benchmarks.ReadPerformanceDriver;
import org.multiverse.benchmarks.ThisReadPerformanceDriver;

public class BenchmarkMain {
    public static void main(String[] args) {
        FileBasedBenchmarkResultRepository repository = new FileBasedBenchmarkResultRepository();
        DefaultBenchmarkRunner runner = new DefaultBenchmarkRunner((BenchmarkResultRepository)repository);
        runner.execute(new Benchmark[]{BenchmarkMain.createConcurrentUpdateBenchmark()});
        GraphMain.main((String[])new String[]{"/tmp"});
    }

    private static Benchmark createThisReadPerformanceBenchmark() {
        TestCase testCase = new TestCase();
        testCase.setProperty("readCount", (Object)1000000000L);
        Benchmark benchmark = new Benchmark();
        benchmark.setDriverClass(ThisReadPerformanceDriver.class);
        benchmark.setBenchmarkName("ThisReadPerformanceDriver");
        benchmark.getTestCases().add(testCase);
        return benchmark;
    }

    private static Benchmark createSetterInLoopDriver() {
        TestCase fieldTestCase = new TestCase();
        fieldTestCase.setProperty("loopSize", (Object)4000000000L);
        fieldTestCase.setProperty("writeType", (Object)"field");
        TestCase setterTestCase = new TestCase();
        setterTestCase.setProperty("loopSize", (Object)4000000000L);
        setterTestCase.setProperty("writeType", (Object)"setter");
        TestCase localTestCase = new TestCase();
        localTestCase.setProperty("loopSize", (Object)4000000000L);
        localTestCase.setProperty("writeType", (Object)"local");
        Benchmark benchmark = new Benchmark();
        benchmark.setDriverClass(PropertyAccessorDriver.class.getName());
        benchmark.setBenchmarkName("SetterInLoopDriver");
        benchmark.getTestCases().add(setterTestCase);
        benchmark.getTestCases().add(fieldTestCase);
        benchmark.getTestCases().add(localTestCase);
        return benchmark;
    }

    private static Benchmark createConcurrentUpdateBenchmark() {
        TestCase testCase = new TestCase();
        testCase.setProperty("incCountPerThread", (Object)10000000);
        testCase.setProperty("threadCount", (Object)1);
        Benchmark benchmark = new Benchmark();
        benchmark.setDriverClass(ConcurrentUpdateDriver.class.getName());
        benchmark.setBenchmarkName("ConcurrentUpdate");
        benchmark.getTestCases().add(testCase);
        return benchmark;
    }

    private static Benchmark createConcurrentUpdateClassicLockBenchmark() {
        TestCase testCase = new TestCase();
        testCase.setProperty("incCountPerThread", (Object)10000000);
        testCase.setProperty("threadCount", (Object)8);
        Benchmark benchmark = new Benchmark();
        benchmark.setDriverClass(ConcurrentUpdateWithIntrinsicLockDriver.class.getName());
        benchmark.setBenchmarkName("ConcurrentUpdateClassicLock");
        benchmark.getTestCases().add(testCase);
        return benchmark;
    }

    private static Benchmark createNonConcurrentUpdateBenchmark() {
        TestCase testCase = new TestCase();
        testCase.setProperty("incCountPerThread", (Object)10000000);
        testCase.setProperty("threadCount", (Object)8);
        Benchmark benchmark = new Benchmark();
        benchmark.setDriverClass(NonConcurrentUpdateDriver.class.getName());
        benchmark.setBenchmarkName("NonConcurrentUpdate");
        benchmark.getTestCases().add(testCase);
        return benchmark;
    }

    private static Benchmark createReadPerformanceBenchmark() {
        TestCase readonlyTestCase = new TestCase();
        readonlyTestCase.setProperty("readCountPerThread", (Object)3000000);
        readonlyTestCase.setProperty("threadCount", (Object)1);
        readonlyTestCase.setProperty("readonly", (Object)true);
        TestCase updateTestCase = new TestCase();
        updateTestCase.setProperty("readCountPerThread", (Object)3000000);
        updateTestCase.setProperty("threadCount", (Object)1);
        updateTestCase.setProperty("readonly", (Object)false);
        Benchmark benchmark = new Benchmark();
        benchmark.setDriverClass(ReadPerformanceDriver.class.getName());
        benchmark.setBenchmarkName("ReadPerformance");
        benchmark.getTestCases().add(readonlyTestCase);
        benchmark.getTestCases().add(updateTestCase);
        return benchmark;
    }
}

