/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.benchmarks;

import org.benchy.AbstractBenchmarkDriver;
import org.benchy.DriverParameter;
import org.benchy.TestCase;
import org.benchy.TestCaseResult;
import org.junit.Assert;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;

public class PropertyAccessorDriver
extends AbstractBenchmarkDriver {
    @DriverParameter
    private long loopSize;
    @DriverParameter
    private String writeType;
    private LongRef ref;

    public void preRun(TestCase testCase) {
        this.ref = new LongRef();
    }

    public void run() {
        if (this.writeType.equals("field")) {
            this.ref.loopField(this.loopSize);
        } else if (this.writeType.equals("setter")) {
            this.ref.loopSetter(this.loopSize);
        } else if (this.writeType.equals("local")) {
            this.ref.loopLocal(this.loopSize);
        } else {
            throw new RuntimeException(String.format("Unrecognized writeType '%s'", this.writeType));
        }
    }

    public void postRun(TestCaseResult caseResult) {
        Assert.assertEquals((long)(this.loopSize - 1L), (long)this.ref.getValue());
        long durationNs = caseResult.getLongProperty("duration(ns)");
        double nsPerSet = (double)this.loopSize * 1.0 / (double)durationNs;
        caseResult.put("operation(ns)", (Object)nsPerSet);
    }

    @TransactionalObject
    private static class LongRef {
        private long value;

        private LongRef() {
        }

        @TransactionalMethod(readonly=true)
        public long getValue() {
            return this.value;
        }

        public void loopSetter(long loopSize) {
            for (long k = 0L; k < loopSize; ++k) {
                this.set(k);
            }
        }

        public void loopField(long loopSize) {
            long k = 0L;
            while (k < loopSize) {
                this.value = k++;
            }
        }

        public void loopLocal(long loopSize) {
            long tmp = this.value;
            long k = 0L;
            while (k < loopSize) {
                tmp = k++;
            }
            this.value = tmp;
        }

        private void set(long newValue) {
            this.value = newValue;
        }
    }
}

