/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.benchmarks;

import java.util.concurrent.TimeUnit;
import org.benchy.AbstractBenchmarkDriver;
import org.benchy.DriverParameter;
import org.benchy.TestCase;
import org.benchy.TestCaseResult;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.transactional.refs.IntRef;

public class UpdateTransactionLengthDriver
extends AbstractBenchmarkDriver {
    @DriverParameter
    private int transactionCount;
    @DriverParameter
    private int transactionLength;
    private IntRef[] refs;

    public void preRun(TestCase testCase) {
        this.refs = new IntRef[this.transactionLength];
        for (int k = 0; k < this.transactionLength; ++k) {
            this.refs[k] = new IntRef();
        }
    }

    public void run() {
        for (int k = 0; k < this.transactionCount; ++k) {
            this.incAll();
        }
    }

    @TransactionalMethod
    public void incAll() {
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k].inc();
        }
    }

    public void postRun(TestCaseResult caseResult) {
        caseResult.put("transactionCount", (Object)this.transactionCount);
        double transactionsPerSecond = 1.0 * (double)this.transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)caseResult.getLongProperty("duration(ns)");
        caseResult.put("transactions/s", (Object)transactionsPerSecond);
    }
}

