/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.benchmarks;

import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;

public class WritePerformanceTest {
    private int readCount;
    private int threadCount;
    private ReadThread[] threads;
    private Ref ref;
    private boolean automaticReadTracking;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.readCount = 100000000;
        this.threadCount = 1;
        this.threads = new ReadThread[this.threadCount];
        for (int k = 0; k < this.threads.length; ++k) {
            this.threads[k] = new ReadThread(k);
        }
        this.ref = new Ref();
    }

    @Test
    public void testWithReadTracking() {
        this.test(true);
    }

    @Test
    public void testWithoutReadTracking() {
        this.test(false);
    }

    public void test(boolean automaticReadTracking) {
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
        this.automaticReadTracking = automaticReadTracking;
        int transactionCount = this.threadCount * this.readCount;
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", TestUtils.format((double)transactionsPerSecond));
    }

    @TransactionalObject
    static class Ref {
        private int value;

        Ref() {
        }

        public int get() {
            return this.value;
        }

        @TransactionalMethod(readonly=false, trackReads=false)
        public void incWithoutReadTracking() {
            ++this.value;
        }

        @TransactionalMethod(readonly=false, trackReads=true)
        public void incWithReadTracking() {
            ++this.value;
        }
    }

    public class ReadThread
    extends TestThread {
        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < WritePerformanceTest.this.readCount; ++k) {
                if (k % 10000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                this.write();
            }
        }

        public void write() {
            if (WritePerformanceTest.this.automaticReadTracking) {
                WritePerformanceTest.this.ref.incWithReadTracking();
            } else {
                WritePerformanceTest.this.ref.incWithoutReadTracking();
            }
        }
    }
}

