/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.CountDownCommitBarrier;
import org.multiverse.commitbarriers.JoinCommitThread;

public class CountDownCommitBarrier_incPartiesTest {
    @Test
    public void whenNegativeNumber_thenIllegalArgumentException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(10);
        try {
            barrier.incParties(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertEquals((long)10L, (long)barrier.getParties());
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenZeroExtraParties() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(5);
        barrier.incParties(0);
        Assert.assertEquals((long)5L, (long)barrier.getParties());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenPositiveNumber() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(10);
        barrier.incParties(5);
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertEquals((long)15L, (long)barrier.getParties());
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenPartiesAdded_commitTakesLonger() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(2);
        barrier.incParties(1);
        barrier.countDown();
        barrier.countDown();
        Assert.assertTrue((boolean)barrier.isClosed());
        barrier.countDown();
        Assert.assertTrue((boolean)barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }

    @Test
    public void whenPendingTransactions() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(3);
        JoinCommitThread t1 = new JoinCommitThread(barrier);
        JoinCommitThread t2 = new JoinCommitThread(barrier);
        TestUtils.startAll((TestThread[])new TestThread[]{t1, t2});
        TestUtils.sleepMs((long)500L);
        Assert.assertTrue((boolean)barrier.isClosed());
        barrier.incParties(1);
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t1, t2});
        Assert.assertTrue((boolean)barrier.isClosed());
        Assert.assertEquals((long)2L, (long)barrier.getNumberWaiting());
        Assert.assertEquals((long)4L, (long)barrier.getParties());
    }

    @Test
    public void whenAborted_thenCommitBarrierOpenException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        barrier.abort();
        try {
            barrier.incParties(10);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)barrier.getParties());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertTrue((boolean)barrier.isAborted());
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(0);
        try {
            barrier.incParties();
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)barrier.getParties());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
        Assert.assertTrue((boolean)barrier.isCommitted());
    }
}

