/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.CountDownCommitBarrier;

public class CountDownCommitBarrier_registerOnAbortTaskTest {
    @Test
    public void whenNullTask_thenNullPointerException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        try {
            barrier.registerOnAbortTask(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenAborted_thenTaskExecuted() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        barrier.registerOnAbortTask(task);
        barrier.abort();
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void whenCommitted_thenTaskNotExecuted() throws InterruptedException {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        barrier.registerOnAbortTask(task);
        barrier.countDown();
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void whenTaskThrowsRuntimeException_thenOtherTasksNotExecuted() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        Runnable task1 = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doThrow((Throwable)new FakeException()).when((Object)task1)).run();
        Runnable task2 = (Runnable)Mockito.mock(Runnable.class);
        barrier.registerOnAbortTask(task1);
        barrier.registerOnAbortTask(task2);
        try {
            barrier.abort();
            Assert.fail();
        }
        catch (FakeException expected) {
            // empty catch block
        }
        ((Runnable)Mockito.verify((Object)task2, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(0);
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        try {
            barrier.registerOnAbortTask(task);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isCommitted());
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void whenAborted_thenCommitBarrierOpenException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        barrier.abort();
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        try {
            barrier.registerOnAbortTask(task);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isAborted());
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.never())).run();
    }

    static class FakeException
    extends RuntimeException {
        FakeException() {
        }
    }
}

