/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.VetoCommitBarrier;
import org.multiverse.transactional.refs.IntRef;

public class VetoCommitBarrier_abortTest {
    private VetoCommitBarrier barrier;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenNoPreparedTransactions() {
        this.barrier = new VetoCommitBarrier();
        this.barrier.abort();
        Assert.assertTrue((boolean)this.barrier.isAborted());
    }

    @Test
    public void whenPendingTransactions_theyAreAborted() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        IntRef ref = new IntRef();
        IncThread thread1 = new IncThread(ref);
        IncThread thread2 = new IncThread(ref);
        TestUtils.startAll((TestThread[])new TestThread[]{thread1, thread2});
        TestUtils.sleepMs((long)500L);
        this.barrier.abort();
        thread1.join();
        thread2.join();
        Assert.assertEquals((long)0L, (long)ref.get());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{thread1.tx});
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{thread2.tx});
        thread1.assertFailedWithException(CommitBarrierOpenException.class);
        thread2.assertFailedWithException(CommitBarrierOpenException.class);
    }

    @Test
    public void whenBarrierAborted_thenCallIgnored() {
        this.barrier = new VetoCommitBarrier();
        this.barrier.abort();
        this.barrier.abort();
        Assert.assertTrue((boolean)this.barrier.isAborted());
    }

    @Test
    public void whenBarrierCommitted_thenCommitBarrierOpenException() {
        this.barrier = new VetoCommitBarrier();
        this.barrier.vetoCommit();
        try {
            this.barrier.abort();
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isCommitted());
    }

    public class IncThread
    extends TestThread {
        private final IntRef ref;
        private Transaction tx;

        public IncThread(IntRef ref) {
            super("IncThread");
            this.setPrintStackTrace(false);
            this.ref = ref;
        }

        @TransactionalMethod
        public void doRun() throws Exception {
            this.tx = ThreadLocalTransaction.getThreadLocalTransaction();
            this.ref.inc();
            VetoCommitBarrier_abortTest.this.barrier.joinCommit(this.tx);
        }
    }
}

