/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.commitbarriers.VetoCommitBarrier;

public class VetoCommitBarrier_awaitOpenTest {
    private VetoCommitBarrier barrier;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenStartInterrupted_thenInterruptedException() {
        this.barrier = new VetoCommitBarrier();
        Thread.currentThread().interrupt();
        try {
            this.barrier.awaitOpen();
            Assert.fail();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isClosed());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenInterruptedWhileWaiting_thenInterruptedException() {
        this.barrier = new VetoCommitBarrier();
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                try {
                    VetoCommitBarrier_awaitOpenTest.this.barrier.awaitOpen();
                    Assert.fail();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        t.interrupt();
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    @Test
    public void whenAbortedWhileWaiting() {
        this.barrier = new VetoCommitBarrier();
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                VetoCommitBarrier_awaitOpenTest.this.barrier.awaitOpen();
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        this.barrier.abort();
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    @Test
    public void whenCommittedWhileWaiting() {
        this.barrier = new VetoCommitBarrier();
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                VetoCommitBarrier_awaitOpenTest.this.barrier.awaitOpen();
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        this.barrier.vetoCommit();
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    @Test
    public void whenCommitted() throws InterruptedException {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.vetoCommit();
        barrier.awaitOpen();
        Assert.assertTrue((boolean)barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }

    @Test
    public void whenAborted() throws InterruptedException {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.abort();
        barrier.awaitOpen();
        Assert.assertTrue((boolean)barrier.isAborted());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }
}

