/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.VetoCommitBarrier;
import org.multiverse.transactional.refs.IntRef;

public class VetoCommitBarrier_joinCommitTest {
    private Stm stm;
    private TransactionFactory txFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenTransactionNull_thenNullPointerException() throws InterruptedException {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        try {
            barrier.joinCommit(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isClosed());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }

    @Test
    public void whenTransactionPreparable_thenAdded() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        IntRef ref = new IntRef();
        IncThread thread = new IncThread(ref, barrier);
        thread.start();
        TestUtils.sleepMs((long)1000L);
        TestUtils.assertAlive((Thread[])new Thread[]{thread});
        Assert.assertTrue((boolean)barrier.isClosed());
        Assert.assertEquals((long)1L, (long)barrier.getNumberWaiting());
    }

    @Test
    public void whenTransactionPrepared_thenAdded() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        IntRef ref = new IntRef();
        IncThread thread = new IncThread(ref, barrier, true);
        thread.start();
        TestUtils.sleepMs((long)1000L);
        TestUtils.assertAlive((Thread[])new Thread[]{thread});
        Assert.assertTrue((boolean)barrier.isClosed());
        Assert.assertEquals((long)1L, (long)barrier.getNumberWaiting());
    }

    @Test
    public void whenPrepareFails() throws InterruptedException {
        VetoCommitBarrier group = new VetoCommitBarrier();
        IntRef ref = new IntRef();
        FailToPrepareThread thread = new FailToPrepareThread(group, ref);
        thread.start();
        TestUtils.sleepMs((long)500L);
        ref.inc();
        thread.join();
        thread.assertFailedWithException(TooManyRetriesException.class);
        Assert.assertEquals((long)0L, (long)group.getNumberWaiting());
    }

    @Test
    public void whenTransactionAborted_thenDeadTransactionException() throws InterruptedException {
        Transaction tx = this.txFactory.start();
        tx.abort();
        VetoCommitBarrier group = new VetoCommitBarrier();
        try {
            group.joinCommit(tx);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)group.isClosed());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)group.getNumberWaiting());
    }

    @Test
    public void whenTransactionCommitted_thenDeadTransactionException() throws InterruptedException {
        Transaction tx = this.txFactory.start();
        tx.commit();
        VetoCommitBarrier group = new VetoCommitBarrier();
        try {
            group.joinCommit(tx);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)group.isClosed());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)group.getNumberWaiting());
    }

    @Test
    public void whenBarrierAborted_thenCommitBarrierOpenException() throws InterruptedException {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.abort();
        Transaction tx = this.txFactory.start();
        try {
            barrier.joinCommit(tx);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)barrier.isAborted());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() throws InterruptedException {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.vetoCommit();
        Transaction tx = this.txFactory.start();
        try {
            barrier.joinCommit(tx);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }

    public class IncThread
    extends TestThread {
        private final IntRef ref;
        private final VetoCommitBarrier barrier;
        private Transaction tx;
        private boolean prepare;

        public IncThread(IntRef ref, VetoCommitBarrier barrier) {
            this(ref, barrier, false);
        }

        public IncThread(IntRef ref, VetoCommitBarrier barrier, boolean prepare) {
            super("IncThread");
            this.barrier = barrier;
            this.ref = ref;
            this.prepare = prepare;
        }

        @TransactionalMethod
        public void doRun() throws Exception {
            this.tx = ThreadLocalTransaction.getThreadLocalTransaction();
            this.ref.inc();
            if (this.prepare) {
                this.tx.prepare();
            }
            this.barrier.joinCommit(this.tx);
        }
    }

    class FailToPrepareThread
    extends TestThread {
        final VetoCommitBarrier group;
        final IntRef ref;

        FailToPrepareThread(VetoCommitBarrier group, IntRef ref) {
            this.group = group;
            this.ref = ref;
            this.setPrintStackTrace(false);
        }

        @TransactionalMethod(maxRetries=0)
        public void doRun() throws Exception {
            TestUtils.sleepMs((long)1000L);
            this.ref.inc();
            this.group.joinCommit(ThreadLocalTransaction.getThreadLocalTransaction());
        }
    }
}

