/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.commitbarriers.VetoCommitBarrier;

public class VetoCommitBarrier_tryAwaitOpenTest {
    private VetoCommitBarrier barrier;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenNullTimeout_thenNullPointerException() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        try {
            this.barrier.tryAwaitOpen(1L, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isClosed());
    }

    @Test
    public void whenAlreadyInterrupted() {
        Thread.currentThread().interrupt();
        this.barrier = new VetoCommitBarrier();
        try {
            this.barrier.tryAwaitOpen(1L, TimeUnit.DAYS);
            Assert.fail();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isClosed());
    }

    @Test
    public void whenInterruptedWhileWaiting() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        TestThread thread = new TestThread(){

            public void doRun() throws Exception {
                VetoCommitBarrier_tryAwaitOpenTest.this.barrier.tryAwaitOpen(1L, TimeUnit.DAYS);
            }
        };
        thread.setPrintStackTrace(false);
        thread.start();
        TestUtils.sleepMs((long)500L);
        thread.interrupt();
        thread.join();
        thread.assertFailedWithException(InterruptedException.class);
    }

    @Test
    public void whenCommittedWhileWaiting() {
        this.barrier = new VetoCommitBarrier();
        TestThread thread = new TestThread(){

            public void doRun() throws Exception {
                VetoCommitBarrier_tryAwaitOpenTest.this.barrier.tryAwaitOpen(1L, TimeUnit.DAYS);
            }
        };
        thread.setPrintStackTrace(false);
        thread.start();
        TestUtils.sleepMs((long)500L);
        thread.interrupt();
    }

    @Test
    public void whenAbortedWhileWaiting() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        TestThread thread = new TestThread(){

            public void doRun() throws Exception {
                boolean result = VetoCommitBarrier_tryAwaitOpenTest.this.barrier.tryAwaitOpen(1L, TimeUnit.DAYS);
                Assert.assertTrue((boolean)result);
            }
        };
        thread.setPrintStackTrace(false);
        thread.start();
        TestUtils.sleepMs((long)500L);
        this.barrier.abort();
        TestUtils.joinAll((TestThread[])new TestThread[]{thread});
    }

    @Test
    public void whenTimeout() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        TestThread thread = new TestThread(){

            public void doRun() throws Exception {
                boolean result = VetoCommitBarrier_tryAwaitOpenTest.this.barrier.tryAwaitOpen(1L, TimeUnit.SECONDS);
                Assert.assertFalse((boolean)result);
            }
        };
        thread.setPrintStackTrace(false);
        thread.start();
        TestUtils.joinAll((TestThread[])new TestThread[]{thread});
    }

    @Test
    public void whenAborted() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        this.barrier.abort();
        boolean success = this.barrier.tryAwaitOpen(1L, TimeUnit.DAYS);
        Assert.assertTrue((boolean)this.barrier.isAborted());
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void whenCommitted() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        this.barrier.vetoCommit();
        this.barrier.awaitOpen();
        Assert.assertTrue((boolean)this.barrier.isCommitted());
    }
}

