/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.LongRef;

public class IsolatedChangeStressTest {
    private int threadCount = 4;
    private volatile boolean stop;
    private LongRef ref;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stop = false;
        this.ref = new LongRef();
    }

    @Test
    public void test() {
        TestThread[] threads = new WriteThread[this.threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new WriteThread(k);
        }
        TestUtils.startAll((TestThread[])threads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])threads);
        Assert.assertEquals((long)this.sum((WriteThread[])threads), (long)this.ref.get());
        System.out.println("end value is : " + this.ref);
    }

    public long sum(WriteThread[] threads) {
        long sum = 0L;
        for (WriteThread thread : threads) {
            sum += thread.count;
        }
        return sum;
    }

    class WriteThread
    extends TestThread {
        private long count;

        public WriteThread(int id) {
            super("WriteThread-" + id);
            this.count = 0L;
        }

        public void doRun() throws Exception {
            while (!IsolatedChangeStressTest.this.stop) {
                IsolatedChangeStressTest.this.ref.inc();
                ++this.count;
                if (this.count % 5000000L != 0L) continue;
                System.out.printf("%s is at %s\n", this.getName(), this.count);
            }
        }
    }
}

