/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.IntRef;

public class ReadonlyRepeatableReadStressTest {
    private volatile boolean stop;
    private IntRef ref;
    private int readThreadCount = 5;
    private int modifyThreadCount = 2;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.ref = new IntRef(0);
        this.stop = false;
    }

    @Test
    public void test() {
        TestThread[] modifyThreads = new ModifyThread[this.modifyThreadCount];
        for (int k = 0; k < this.modifyThreadCount; ++k) {
            modifyThreads[k] = new ModifyThread(k);
        }
        TestThread[] readerThread = new ReadThread[this.readThreadCount];
        for (int k = 0; k < this.readThreadCount; ++k) {
            readerThread[k] = new ReadThread(k);
        }
        TestUtils.startAll((TestThread[])modifyThreads);
        TestUtils.startAll((TestThread[])readerThread);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])modifyThreads);
        TestUtils.joinAll((TestThread[])readerThread);
    }

    class ReadThread
    extends TestThread {
        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() {
            int k = 0;
            while (!ReadonlyRepeatableReadStressTest.this.stop) {
                switch (k % 4) {
                    case 0: {
                        this.readUsingUpdateTransaction();
                        break;
                    }
                    case 1: {
                        this.readUsingReadonlyTransaction();
                        break;
                    }
                    case 2: {
                        this.readUsingReadtrackingReadonlyTransaction();
                        break;
                    }
                    case 3: {
                        this.readUsingReadtrackingUpdateTransaction();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                ++k;
            }
        }

        @TransactionalMethod(readonly=true, trackReads=false)
        private void readUsingReadonlyTransaction() {
            this.read();
        }

        @TransactionalMethod(readonly=false, trackReads=false)
        private void readUsingUpdateTransaction() {
            this.read();
        }

        @TransactionalMethod(readonly=true, trackReads=true)
        private void readUsingReadtrackingReadonlyTransaction() {
            this.read();
        }

        @TransactionalMethod(readonly=false, trackReads=true)
        private void readUsingReadtrackingUpdateTransaction() {
            this.read();
        }

        private void read() {
            int firstTime = ReadonlyRepeatableReadStressTest.this.ref.get();
            TestUtils.sleepRandomMs((int)2);
            int secondTime = ReadonlyRepeatableReadStressTest.this.ref.get();
            Assert.assertEquals((long)firstTime, (long)secondTime);
        }
    }

    class ModifyThread
    extends TestThread {
        public ModifyThread(int id) {
            super("ModifyThread-" + id);
        }

        public void doRun() {
            while (!ReadonlyRepeatableReadStressTest.this.stop) {
                ReadonlyRepeatableReadStressTest.this.ref.inc();
                TestUtils.sleepRandomMs((int)5);
            }
        }
    }
}

