/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.notification;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.IntRef;

public class LargeNumberOfWaitersStressTest {
    private IntRef waiterLatch;
    private IntRef notifyLatch;
    private int totalWakeupCount = 1000000;
    private int wakeupCount = 1000;
    private int waiterThreadCount = 20;
    private AtomicInteger wakeupCountDown = new AtomicInteger();
    private AtomicInteger notifyCountDown = new AtomicInteger();

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        this.wakeupCountDown.set(this.totalWakeupCount);
        this.notifyCountDown.set(this.totalWakeupCount);
        this.waiterLatch = new IntRef(0);
        this.notifyLatch = new IntRef(1);
        NotifyThread notifyThread = new NotifyThread(0);
        TestThread[] waiterThreads = this.createWaiterThreads();
        TestUtils.startAll((TestThread[])waiterThreads);
        TestUtils.startAll((TestThread[])new TestThread[]{notifyThread});
        TestUtils.joinAll((TestThread[])waiterThreads);
        TestUtils.joinAll((TestThread[])new TestThread[]{notifyThread});
        Assert.assertEquals((long)0L, (long)this.waiterLatch.get());
        Assert.assertEquals((long)1L, (long)this.notifyLatch.get());
    }

    private WaiterThread[] createWaiterThreads() {
        WaiterThread[] threads = new WaiterThread[this.waiterThreadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new WaiterThread(k);
        }
        return threads;
    }

    class WaiterThread
    extends TestThread {
        public WaiterThread(int id) {
            super("WaiterThread-" + id);
        }

        public void doRun() {
            while (LargeNumberOfWaitersStressTest.this.wakeupCountDown.getAndDecrement() > 0) {
                this.doWait();
            }
            System.out.println(this.getName() + " is finished");
        }

        @TransactionalMethod
        public void doWait() {
            if (LargeNumberOfWaitersStressTest.this.waiterLatch.get() <= 0) {
                StmUtils.retry();
            }
            LargeNumberOfWaitersStressTest.this.waiterLatch.dec();
            if (LargeNumberOfWaitersStressTest.this.waiterLatch.get() == 0) {
                LargeNumberOfWaitersStressTest.this.notifyLatch.set(1);
            }
        }
    }

    class NotifyThread
    extends TestThread {
        public NotifyThread(int id) {
            super("NotifyThread-" + id);
        }

        public void doRun() {
            int wakeupCount;
            while ((wakeupCount = this.checkout()) > 0) {
                this.wakeup(wakeupCount);
            }
        }

        public int checkout() {
            int result;
            int remaining;
            boolean succes;
            do {
                result = (remaining = LargeNumberOfWaitersStressTest.this.notifyCountDown.get()) >= LargeNumberOfWaitersStressTest.this.wakeupCount ? LargeNumberOfWaitersStressTest.this.wakeupCount : remaining;
            } while (!(succes = LargeNumberOfWaitersStressTest.this.notifyCountDown.compareAndSet(remaining, remaining - result)));
            return result;
        }

        @TransactionalMethod
        public void wakeup(int count) {
            if (LargeNumberOfWaitersStressTest.this.notifyLatch.get() == 0) {
                StmUtils.retry();
            }
            LargeNumberOfWaitersStressTest.this.notifyLatch.set(0);
            LargeNumberOfWaitersStressTest.this.waiterLatch.set(count);
        }
    }
}

