/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.notification;

import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.templates.OrElseTemplate;
import org.multiverse.transactional.refs.IntRef;

public class OrElseStressTest {
    private int waitCountPerWaiter = 5000;
    private int waitingThreadCount = 20;
    private int refCount = 100;
    private IntRef[] refs;
    private WaitingThread[] waitingThreads;
    private NotifyThread notifyThread;

    @Before
    public void setUp() {
        int k;
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.refs = new IntRef[this.refCount];
        for (k = 0; k < this.refCount; ++k) {
            this.refs[k] = new IntRef();
        }
        this.waitingThreads = new WaitingThread[this.waitingThreadCount];
        for (k = 0; k < this.waitingThreads.length; ++k) {
            this.waitingThreads[k] = new WaitingThread(k);
        }
        this.notifyThread = new NotifyThread();
    }

    @Test
    public void test() {
        TestUtils.startAll((TestThread[])new TestThread[]{this.notifyThread});
        TestUtils.startAll((TestThread[])this.waitingThreads);
        TestUtils.joinAll((TestThread[])this.waitingThreads);
        TestUtils.joinAll((TestThread[])new TestThread[]{this.notifyThread});
    }

    class WaitingThread
    extends TestThread {
        public WaitingThread(int id) {
            super("WaitingThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < OrElseStressTest.this.waitCountPerWaiter; ++k) {
                if (k % 1000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                this.decreaseRefContainingOne(0);
            }
        }

        @TransactionalMethod
        public void decreaseRefContainingOne(final int refIndex) {
            new OrElseTemplate(){

                public Object either(Transaction tx) {
                    OrElseStressTest.this.refs[refIndex].await(1);
                    OrElseStressTest.this.refs[refIndex].dec();
                    return null;
                }

                public Object orelse(Transaction t) {
                    if (refIndex == OrElseStressTest.this.refs.length - 1) {
                        StmUtils.retry();
                    } else {
                        WaitingThread.this.decreaseRefContainingOne(refIndex + 1);
                    }
                    return null;
                }
            }.execute();
        }
    }

    class NotifyThread
    extends TestThread {
        public NotifyThread() {
            super("NotifyThread");
        }

        public void doRun() throws Exception {
            for (int k = 0; k < OrElseStressTest.this.waitCountPerWaiter * OrElseStressTest.this.waitingThreadCount; ++k) {
                if (k % 10000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                this.awaitAllZero();
                int randomIndex = TestUtils.randomInt((int)(OrElseStressTest.this.refs.length - 1));
                OrElseStressTest.this.refs[randomIndex].inc();
            }
        }

        @TransactionalMethod(readonly=false, trackReads=true)
        public void awaitAllZero() {
            for (int k = 0; k < OrElseStressTest.this.refs.length; ++k) {
                if (OrElseStressTest.this.refs[k].get() != 1) continue;
                StmUtils.retry();
            }
        }
    }
}

