/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.scalability;

import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.integrationtests.Ref;

public class IndependentScalabilityPerformanceTest {
    private Stm stm;
    private long updateCount = 5000000L;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void test() {
        int k;
        int processors = Runtime.getRuntime().availableProcessors();
        long[] resultsInMs = new long[processors];
        for (k = 0; k < processors; ++k) {
            resultsInMs[k] = this.test(k + 1);
        }
        for (k = 0; k < processors; ++k) {
            System.out.printf("%s processors took %s seconds\n", k + 1, resultsInMs[k]);
        }
    }

    public long test(int threadCount) {
        System.out.println("--------------------------------------------------------");
        System.out.printf("starting with %s threads\n", threadCount);
        System.out.println("--------------------------------------------------------");
        CheapLatch startLatch = new CheapLatch();
        TestThread[] threads = this.createThreads((Latch)startLatch, threadCount);
        TestUtils.startAll((TestThread[])threads);
        long startMs = System.currentTimeMillis();
        startLatch.open();
        TestUtils.joinAll((TestThread[])threads);
        return System.currentTimeMillis() - startMs;
    }

    public MyThread[] createThreads(Latch startLatch, int threadCount) {
        MyThread[] threads = new MyThread[threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new MyThread(k, new Ref(0), startLatch);
        }
        return threads;
    }

    class MyThread
    extends TestThread {
        private final Ref ref;
        private final Latch startLatch;

        public MyThread(int id, Ref ref, Latch startLatch) {
            super("Thread-" + id);
            this.startLatch = startLatch;
            this.ref = ref;
        }

        public void doRun() {
            this.startLatch.awaitUninterruptible();
            int k = 0;
            while ((long)k < IndependentScalabilityPerformanceTest.this.updateCount) {
                this.ref.inc();
                if (k % 5000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
        }
    }
}

