/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.stability;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;

public class CycleHandlingStressTest {
    private Stm stm;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = GlobalStmInstance.getGlobalStmInstance();
    }

    public Transaction startUpdateTransaction() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void directCycle() {
        Transaction t = this.startUpdateTransaction();
        SingleLinkedNode node = new SingleLinkedNode();
        node.setNext(node);
        t.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertSame((Object)node, (Object)node.getNext());
    }

    @Test
    public void shortIndirectCycle() {
        Transaction t = this.startUpdateTransaction();
        SingleLinkedNode node1 = new SingleLinkedNode();
        SingleLinkedNode node2 = new SingleLinkedNode();
        node1.setNext(node2);
        node2.setNext(node1);
        t.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertSame((Object)node1.getNext(), (Object)node2);
        Assert.assertSame((Object)node2.getNext(), (Object)node1);
    }

    @Test
    public void longIndirectCycleCommitsWithoutFailure() {
        Transaction t = this.startUpdateTransaction();
        SingleLinkedNode original = this.createLongChain(100000);
        t.commit();
    }

    private SingleLinkedNode createLongChain(int depth) {
        SingleLinkedNode first;
        SingleLinkedNode current = first = new SingleLinkedNode();
        for (int k = 0; k < depth; ++k) {
            SingleLinkedNode newHolder = new SingleLinkedNode();
            current.setNext(newHolder);
            current = newHolder;
        }
        current.setNext(first);
        return first;
    }

    @TransactionalObject
    public static class SingleLinkedNode {
        private SingleLinkedNode next;

        public SingleLinkedNode getNext() {
            return this.next;
        }

        public void setNext(SingleLinkedNode next) {
            this.next = next;
        }
    }
}

