/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.traditional;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;

public class MutexStressTest {
    private volatile boolean stop;
    private int accountCount = 50;
    private int threadCount = TestUtils.processorCount() * 4;
    private IntValue[] intValues;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stop = false;
    }

    @Test
    public void test() {
        this.intValues = new IntValue[this.accountCount];
        for (int k = 0; k < this.accountCount; ++k) {
            this.intValues[k] = new IntValue();
        }
        TestThread[] threads = new IncThread[this.threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new IncThread(k);
        }
        TestUtils.startAll((TestThread[])threads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])threads);
        Assert.assertEquals((long)this.sum((IncThread[])threads), (long)this.sum(this.intValues));
        System.out.println("total increments: " + this.sum((IncThread[])threads));
    }

    int sum(IncThread[] threads) {
        int result = 0;
        for (IncThread thread : threads) {
            result += thread.count;
        }
        return result;
    }

    int sum(IntValue[] intValues) {
        int result = 0;
        for (IntValue intValue2 : intValues) {
            result += intValue2.balance;
        }
        return result;
    }

    @TransactionalObject
    class Mutex {
        boolean locked = false;

        Mutex() {
        }

        public void lock() {
            if (this.locked) {
                StmUtils.retry();
            }
            this.locked = true;
        }

        public void unlock() {
            this.locked = false;
        }
    }

    class IntValue {
        final Mutex mutex;
        int balance;

        IntValue() {
            this.mutex = new Mutex();
        }

        public void inc() {
            this.mutex.lock();
            ++this.balance;
            this.mutex.unlock();
        }
    }

    class IncThread
    extends TestThread {
        private int count;

        public IncThread(int id) {
            super("IncThread-" + id);
        }

        public void doRun() throws Exception {
            while (!MutexStressTest.this.stop) {
                IntValue intValue2 = MutexStressTest.this.intValues[TestUtils.randomInt((int)MutexStressTest.this.accountCount)];
                intValue2.inc();
                if (this.count % 100000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), this.count);
                }
                ++this.count;
            }
        }
    }
}

