/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.instrumentation.LongRef;

public class TransactionalClassTransformerIntegrationTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void testInstanceMethod() {
        LongRef v1 = new LongRef(0L);
        this.inc(v1);
        Assert.assertEquals((long)1L, (long)v1.get());
    }

    @TransactionalMethod
    public void inc(LongRef v1) {
        v1.inc();
    }

    @Test
    public void testStaticMethod() {
        LongRef v1 = new LongRef(0L);
        TransactionalClassTransformerIntegrationTest.incStatic(v1);
        Assert.assertEquals((long)1L, (long)v1.get());
    }

    @TransactionalMethod
    public static void incStatic(LongRef v1) {
        v1.inc();
    }

    @Test
    public void testMultipleUpdates() {
        LongRef v1 = new LongRef(0L);
        LongRef v2 = new LongRef(1L);
        LongRef v3 = new LongRef(2L);
        long clockVersion = this.stm.getVersion();
        this.updateToStmClockVersion(v1, v2, v3);
        Assert.assertEquals((long)clockVersion, (long)v1.get());
        Assert.assertEquals((long)clockVersion, (long)v2.get());
        Assert.assertEquals((long)clockVersion, (long)v3.get());
    }

    @TransactionalMethod
    public void updateToStmClockVersion(LongRef ... values) {
        for (LongRef value : values) {
            value.set(this.stm.getVersion());
        }
    }
}

