/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.NonTransactional;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.instrumentation.AlphaReflectionUtils;
import org.multiverse.templates.OrElseTemplate;
import org.multiverse.templates.TransactionTemplate;

public class TranlocalSnapshotTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void intObjectTest() {
        int oldValue = 10;
        int newValue = 100;
        final intObject i = new intObject(10);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue(100);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertEquals((long)10L, (long)i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void booleanObjectTest() {
        boolean oldValue = false;
        boolean newValue = true;
        final booleanObject i = new booleanObject(false);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue(true);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertEquals((Object)false, (Object)i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void shortObjectTest() {
        int oldValue = 10;
        int newValue = 100;
        final shortObject i = new shortObject(10);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue((short)100);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertEquals((long)10L, (long)i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void charObjectTest() {
        int oldValue = 10;
        int newValue = 100;
        final charObject i = new charObject('\n');
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue('d');
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertEquals((long)10L, (long)i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void longObjectTest() {
        long oldValue = 10L;
        long newValue = 100L;
        final longObject i = new longObject(10L);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue(100L);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertEquals((long)10L, (long)i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void doubleObjectTest() {
        double oldValue = 10.0;
        double newValue = 100.0;
        final doubleObject i = new doubleObject(10.0);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue(100.0);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertEquals((double)10.0, (double)i.getValue(), (double)1.0E-4);
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void floatObjectTest() {
        float oldValue = 10.0f;
        float newValue = 100.0f;
        final floatObject i = new floatObject(10.0f);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue(100.0f);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertEquals((double)10.0, (double)i.getValue(), (double)1.0E-6);
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void arrayObjectTest() {
        final int[] oldValue = new int[]{10};
        final int[] newValue = new int[]{100};
        final arrayObject i = new arrayObject(oldValue);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue(newValue);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertSame((Object)oldValue, (Object)i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void nonTxObjectField() {
        String oldValue = "foo";
        String newValue = "bar";
        final StringObject i = new StringObject("foo");
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue("bar");
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertSame((Object)"foo", (Object)i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void txObjectField() {
        String oldValue = "foo";
        String newValue = "bar";
        final TxObjectFieldObject i = new TxObjectFieldObject("foo");
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue("bar");
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertSame((Object)"foo", (Object)i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void testMultipleFieldsObjectTest() {
        final MultipleFieldsObject m = new MultipleFieldsObject(1, 2, 3);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        m.setValue1(100);
                        m.setValue2(200);
                        m.setValue3(300);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertEquals((long)1L, (long)m.getValue1());
                        Assert.assertEquals((long)2L, (long)m.getValue2());
                        Assert.assertEquals((long)3L, (long)m.getValue3());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void privateFieldTest() {
        int oldValue = 10;
        int newValue = 20;
        final PrivateField i = new PrivateField(10);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue(20);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertSame((Object)10, (Object)i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void publicFieldTest() {
        int oldValue = 10;
        int newValue = 20;
        final PublicField i = new PublicField(10);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue(20);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertSame((Object)10, (Object)i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void protectedFieldTest() {
        int oldValue = 10;
        int newValue = 20;
        final ProtectedField i = new ProtectedField(10);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue(20);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertSame((Object)10, (Object)i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void packageFriendlyTest() {
        int oldValue = 10;
        int newValue = 20;
        final PackageFriendlyField i = new PackageFriendlyField(10);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue(20);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertSame((Object)10, (Object)i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void genericFieldTest() {
        final Integer oldValue = 10;
        final Integer newValue = 20;
        final GenericField<Integer> i = new GenericField<Integer>(oldValue);
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                new OrElseTemplate(){

                    public Object orelse(Transaction t) {
                        i.setValue(newValue);
                        return null;
                    }

                    public Object either(Transaction t) {
                        Assert.assertSame((Object)oldValue, i.getValue());
                        return null;
                    }
                }.execute();
                return null;
            }
        }.execute();
    }

    @Test
    public void testFinalField() {
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalSnapshotClass(WithFinalField.class));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalSnapshotField(WithFinalField.class, "included"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsTranlocalSnapshotField(WithFinalField.class, "excluded"));
    }

    @Test
    public void testExcludedField() {
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalSnapshotClass(WithExcludedField.class));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalSnapshotField(WithExcludedField.class, "included"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsTranlocalSnapshotField(WithExcludedField.class, "excluded"));
    }

    @Test
    public void testMultipleFields() {
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalSnapshotClass(TestMultipleFields.class));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalSnapshotField(TestMultipleFields.class, "field1"));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalSnapshotField(TestMultipleFields.class, "field2"));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalSnapshotField(TestMultipleFields.class, "field3"));
    }

    @TransactionalObject
    static class TestMultipleFields {
        int field1;
        int field2;
        int field3;

        TestMultipleFields() {
        }
    }

    @TransactionalObject
    static class WithExcludedField {
        int included;
        @NonTransactional
        int excluded;

        WithExcludedField() {
        }
    }

    @TransactionalObject
    static class WithFinalField {
        int included;
        final int excluded = 0;

        WithFinalField() {
        }
    }

    class GenericField<E> {
        E value;

        GenericField(E value) {
            this.value = value;
        }

        public E getValue() {
            return this.value;
        }

        public void setValue(E value) {
            this.value = value;
        }
    }

    class PackageFriendlyField {
        int value;

        PackageFriendlyField(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    class ProtectedField {
        protected int value;

        ProtectedField(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    class PublicField {
        public int value;

        PublicField(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    static class PrivateField {
        private int value;

        PrivateField(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class MultipleFieldsObject {
        int value1;
        int value2;
        int value3;

        MultipleFieldsObject(int value1, int value2, int value3) {
            this.value1 = value1;
            this.value2 = value2;
            this.value3 = value3;
        }

        public int getValue1() {
            return this.value1;
        }

        public void setValue1(int value1) {
            this.value1 = value1;
        }

        public int getValue2() {
            return this.value2;
        }

        public void setValue2(int value2) {
            this.value2 = value2;
        }

        public int getValue3() {
            return this.value3;
        }

        public void setValue3(int value3) {
            this.value3 = value3;
        }
    }

    @TransactionalObject
    private static class TxObjectFieldObject {
        Object value;

        TxObjectFieldObject(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class StringObject {
        String value;

        StringObject(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class arrayObject {
        int[] value;

        arrayObject(int[] value) {
            this.value = value;
        }

        public int[] getValue() {
            return this.value;
        }

        public void setValue(int[] value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class floatObject {
        float value;

        floatObject(float value) {
            this.value = value;
        }

        public float getValue() {
            return this.value;
        }

        public void setValue(float value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class doubleObject {
        double value;

        doubleObject(double value) {
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class longObject {
        long value;

        longObject(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class charObject {
        char value;

        charObject(char value) {
            this.value = value;
        }

        public char getValue() {
            return this.value;
        }

        public void setValue(char value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class shortObject {
        short value;

        shortObject(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }

        public void setValue(short value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class booleanObject {
        boolean value;

        booleanObject(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class intObject {
        int value;

        intObject(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

