/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.transactional.refs.IntRef;

public class TransactionalObject_ChainOfFieldTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void fieldX() {
        FieldIsTxObjectChain ref = new FieldIsTxObjectChain(null);
        Assert.assertNull((Object)ref.getNext());
        FieldIsTxObjectChain next = new FieldIsTxObjectChain(null);
        ref.setNext(next);
        Assert.assertSame((Object)next, (Object)ref.getNext());
        Assert.assertNull((Object)ref.getNextNext());
    }

    @Test
    public void fieldLongRef() {
        FieldIsTxObjectChain item1 = new FieldIsTxObjectChain(null);
        FieldIsTxObjectChain item2 = new FieldIsTxObjectChain(item1);
        FieldIsTxObjectChain item3 = new FieldIsTxObjectChain(item2);
        FieldIsTxObjectChain item4 = new FieldIsTxObjectChain(item3);
        FieldIsTxObjectChain item5 = new FieldIsTxObjectChain(item4);
        Assert.assertSame((Object)item1, (Object)item5.getNextNextNextNext());
        Assert.assertNull((Object)item4.getNextNextNextNext());
    }

    @Test
    public void fieldThatAreNotAtomicObjects() {
        Node node1 = new Node(null);
        Node node2 = new Node(node1);
        Node node3 = new Node(node2);
        FieldIsNotTxObjectChain root = new FieldIsNotTxObjectChain(node3);
        Assert.assertSame((Object)node3, (Object)root.getNode());
        Assert.assertSame((Object)node2, (Object)root.getNodeNext());
        Assert.assertSame((Object)node1, (Object)root.getNodeNextNext());
        Assert.assertNull((Object)root.getNodeNextNextNext());
    }

    @Test
    public void fieldOfTypeTxObjectIsNotNull() {
        IntRef ref = new IntRef(1);
        FieldWithOtherTypeTxObject o = new FieldWithOtherTypeTxObject(null);
        Assert.assertNull((Object)o.getRef());
    }

    @Test
    public void fieldOfTypeAtomicObjectThatIsNull() {
        IntRef ref = new IntRef(0);
        FieldWithOtherTypeTxObject o = new FieldWithOtherTypeTxObject(ref);
        Assert.assertSame((Object)ref, (Object)o.getRef());
        Assert.assertEquals((long)1L, (long)o.inc());
        Assert.assertEquals((long)1L, (long)ref.get());
    }

    @TransactionalObject
    private static class FieldWithOtherTypeTxObject {
        private IntRef ref;

        private FieldWithOtherTypeTxObject(IntRef ref) {
            this.ref = ref;
        }

        public IntRef getRef() {
            return this.ref;
        }

        public void setRef(IntRef ref) {
            this.ref = ref;
        }

        public int inc() {
            this.ref.inc();
            return this.ref.get();
        }
    }

    class Node {
        Node next;

        Node(Node next) {
            this.next = next;
        }
    }

    @TransactionalObject
    private static class FieldIsNotTxObjectChain {
        Node node;

        private FieldIsNotTxObjectChain(Node node) {
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }

        public Node getNodeNext() {
            return this.node.next;
        }

        public Node getNodeNextNext() {
            return this.node.next.next;
        }

        public Node getNodeNextNextNext() {
            return this.node.next.next.next;
        }
    }

    @TransactionalObject
    private static class FieldIsTxObjectChain {
        FieldIsTxObjectChain next;

        private FieldIsTxObjectChain(FieldIsTxObjectChain next) {
            this.next = next;
        }

        public FieldIsTxObjectChain getNext() {
            return this.next;
        }

        public void setNext(FieldIsTxObjectChain next) {
            this.next = next;
        }

        public FieldIsTxObjectChain getNextNext() {
            return this.next.next;
        }

        public FieldIsTxObjectChain getNextNextNextNext() {
            return this.next.next.next.next;
        }
    }
}

