/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.instrumentation.InstrumentationTestUtils;
import org.multiverse.stms.alpha.AlphaStm;

public class TransactionalObject_ClashingFieldAndMethodTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
    }

    public void tearDown() {
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
    }

    @Test
    public void whenConflictingFieldNothingBadHappens() {
        ObjectWithClashingField o = new ObjectWithClashingField();
        long version = this.stm.getVersion();
        o.set(10);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)o.get());
    }

    @Test
    public void whenConflictingMethod() throws NoSuchFieldException {
        System.out.println("ObjectWithClashingMethod.name: " + ObjectWithClashingMethod.class);
        try {
            ObjectWithClashingMethod o = new ObjectWithClashingMethod();
            o.___getLockOwner();
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
    }

    @TransactionalObject
    static class ObjectWithClashingMethod {
        int x;

        ObjectWithClashingMethod() {
        }

        public String ___getLockOwner() {
            return null;
        }
    }

    @TransactionalObject
    static class ObjectWithClashingField {
        int ___lockOwner;

        ObjectWithClashingField() {
        }

        public void set(int lockOwner) {
            this.___lockOwner = lockOwner;
        }

        public int get() {
            return this.___lockOwner;
        }
    }
}

