/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.instrumentation.InstrumentationTestUtils;
import org.multiverse.javaagent.JavaAgentProblemMonitor;
import org.multiverse.stms.alpha.AlphaTransactionalObject;

public class TransactionalObject_InterfaceTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
    }

    @After
    public void tearDown() {
        Assert.assertFalse((boolean)JavaAgentProblemMonitor.INSTANCE.isProblemFound());
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
    }

    @Test
    public void transactionalInterface() throws NoSuchMethodException {
        Class<TransactionalInterface> clazz = TransactionalInterface.class;
        clazz.getMethod("someMethod", new Class[0]);
    }

    @Test
    public void objectImplementingTransactionalInterface() {
        ObjectImplementingTransactionalInterface o = new ObjectImplementingTransactionalInterface();
        Assert.assertTrue((boolean)(o instanceof AlphaTransactionalObject));
        o.someMethod();
        Assert.assertEquals((long)1L, (long)o.getValue());
    }

    @Test
    public void objectImplementingExtendingInterface() {
        ObjectImplementingExtendingInterface o = new ObjectImplementingExtendingInterface();
        Assert.assertTrue((boolean)(o instanceof AlphaTransactionalObject));
        o.someMethod();
        Assert.assertEquals((long)1L, (long)o.getValue());
    }

    public class ObjectImplementingExtendingInterface
    implements ExtendingInterface {
        private int value;

        @Override
        public void someMethod() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public class ObjectImplementingTransactionalInterface
    implements TransactionalInterface {
        private int value;

        @Override
        public void someMethod() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }
    }

    static interface ExtendingInterface
    extends TransactionalInterface {
    }

    @TransactionalObject
    static interface TransactionalInterface {
        public void someMethod();
    }
}

