/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;

public class TransactionalObject_MethodAccessModifiersTest {
    private Stm stm;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testTxObjectCallingProtectedMethod() {
        TxObjectCallingProtectedMethod o = new TxObjectCallingProtectedMethod();
        long version = this.stm.getVersion();
        o.callDoIt();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)o.getValue());
    }

    @Test
    public void testTxObjectCallingPublicMethod() {
        TxObjectCallingPublicMethod o = new TxObjectCallingPublicMethod();
        long version = this.stm.getVersion();
        o.callDoIt();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)o.getValue());
    }

    @Test
    public void testTxObjectCallingPackageFriendlyMethod() {
        TxObjectCallingPackageFriendlyMethod o = new TxObjectCallingPackageFriendlyMethod();
        long version = this.stm.getVersion();
        o.callDoIt();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)o.getValue());
    }

    @Test
    public void testTxObjectCallingPrivateMethod() {
        TxObjectCallingPrivateMethod privateMethod = new TxObjectCallingPrivateMethod();
        long version = this.stm.getVersion();
        privateMethod.callDoIt();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)privateMethod.getValue());
    }

    @Test
    public void testStaticPublicMethod() {
        TxObjectCallingPublicStaticMethod o = new TxObjectCallingPublicStaticMethod();
        long version = this.stm.getVersion();
        o.doIt();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)o.getValue());
    }

    @Test
    public void testStaticProtectedMethod() {
        TxObjectCallingProtectedStaticMethod o = new TxObjectCallingProtectedStaticMethod();
        long version = this.stm.getVersion();
        o.doIt();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)o.getValue());
    }

    @Test
    public void testStaticPackageFriendlyMethod() {
        TxObjectCallingPackageFriendlyStaticMethod o = new TxObjectCallingPackageFriendlyStaticMethod();
        long version = this.stm.getVersion();
        o.doIt();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)o.getValue());
    }

    @Test
    public void testStaticPrivateMethod() {
        TxObjectCallingPrivateStaticMethod o = new TxObjectCallingPrivateStaticMethod();
        long version = this.stm.getVersion();
        o.doIt();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)o.getValue());
    }

    @Test
    public void testExternalStaticMethod() {
        TxObjectCallingExternalStaticMethod o = new TxObjectCallingExternalStaticMethod();
        long version = this.stm.getVersion();
        o.doIt();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)20L, (long)o.getValue());
    }

    @Test
    public void testSynchronizedMethod() throws NoSuchMethodException {
        Method method = SynchronizedMethod.class.getMethod("doIt", new Class[0]);
        Assert.assertTrue((boolean)Modifier.isSynchronized(method.getModifiers()));
        SynchronizedMethod m = new SynchronizedMethod();
        long version = this.stm.getVersion();
        m.doIt();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)m.getValue());
    }

    @TransactionalObject
    static class SynchronizedMethod {
        private int value;

        SynchronizedMethod() {
        }

        public synchronized void doIt() {
            this.value = 10;
        }

        public int getValue() {
            return this.value;
        }
    }

    @TransactionalObject
    static class TxObjectCallingExternalStaticMethod {
        private int value;

        TxObjectCallingExternalStaticMethod() {
        }

        public void doIt() {
            this.value = Math.max(10, 20);
        }

        public int getValue() {
            return this.value;
        }
    }

    @TransactionalObject
    static class TxObjectCallingPrivateStaticMethod {
        private int value = 0;

        private static int inc(int number) {
            return ++number;
        }

        public void doIt() {
            this.value = TxObjectCallingPrivateStaticMethod.inc(this.value);
        }

        public int getValue() {
            return this.value;
        }
    }

    @TransactionalObject
    static class TxObjectCallingPackageFriendlyStaticMethod {
        private int value = 0;

        static int inc(int number) {
            return ++number;
        }

        void doIt() {
            this.value = TxObjectCallingPackageFriendlyStaticMethod.inc(this.value);
        }

        public int getValue() {
            return this.value;
        }
    }

    @TransactionalObject
    static class TxObjectCallingProtectedStaticMethod {
        private int value = 0;

        protected static int inc(int number) {
            return ++number;
        }

        public void doIt() {
            this.value = TxObjectCallingProtectedStaticMethod.inc(this.value);
        }

        public int getValue() {
            return this.value;
        }
    }

    @TransactionalObject
    static class TxObjectCallingPublicStaticMethod {
        private int value = 0;

        public static int inc(int number) {
            return ++number;
        }

        public void doIt() {
            this.value = TxObjectCallingPublicStaticMethod.inc(this.value);
        }

        public int getValue() {
            return this.value;
        }
    }

    @TransactionalObject
    static class TxObjectCallingPrivateMethod {
        private int value = 0;

        private void doIt() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }

        public void callDoIt() {
            this.doIt();
        }
    }

    @TransactionalObject
    static class TxObjectCallingPackageFriendlyMethod {
        private int value = 0;

        void doIt() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }

        public void callDoIt() {
            this.doIt();
        }
    }

    @TransactionalObject
    static class TxObjectCallingPublicMethod {
        private int value = 0;

        public void doIt() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }

        public void callDoIt() {
            this.doIt();
        }
    }

    @TransactionalObject
    static class TxObjectCallingProtectedMethod {
        private int value = 0;

        protected void doIt() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }

        public void callDoIt() {
            this.doIt();
        }
    }
}

