/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTransactionalObject;

public class TransactionalObject_StaticFieldsTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void txObjectWithOnlyStaticField() {
        long version = this.stm.getVersion();
        TxObjectWithOnlyStaticField o = new TxObjectWithOnlyStaticField();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
    }

    @Test
    public void oneOfTheFieldsIsStatic() {
        int instanceValue = 20;
        int staticValue = 100;
        long version = this.stm.getVersion();
        OneOfTheFieldsIsStatic o = new OneOfTheFieldsIsStatic(instanceValue, staticValue);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertTrue((boolean)(o instanceof AlphaTransactionalObject));
        Assert.assertEquals((long)instanceValue, (long)o.getInstanceField());
        Assert.assertEquals((long)staticValue, (long)o.getStaticFieldThroughInstance());
        Assert.assertEquals((long)staticValue, (long)OneOfTheFieldsIsStatic.staticField);
        Assert.assertEquals((long)staticValue, (long)OneOfTheFieldsIsStatic.getStaticField());
    }

    @TransactionalObject
    public static class OneOfTheFieldsIsStatic {
        static int staticField;
        int instanceField;

        public OneOfTheFieldsIsStatic(int instanceValue, int staticValue) {
            this.instanceField = instanceValue;
            staticField = staticValue;
        }

        public int getInstanceField() {
            return this.instanceField;
        }

        public int getStaticFieldThroughInstance() {
            return staticField;
        }

        public static int getStaticField() {
            return staticField;
        }
    }

    @TransactionalObject
    public static class TxObjectWithOnlyStaticField {
        static int field;
    }
}

