/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTransactionalObject;

public class TransactionalObject_WithFinalsTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void txObjectWithNoFieldsIsNotManaged() {
        long version = this.stm.getVersion();
        NoFields noFields = new NoFields();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertFalse((boolean)(noFields instanceof AlphaTransactionalObject));
    }

    @Test
    public void txObjectWithOneFinalFieldIsNotManaged() {
        long version = this.stm.getVersion();
        OneFinalField o = new OneFinalField(20);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
        Assert.assertEquals((long)20L, (long)o.getValue());
    }

    @Test
    public void txObjectWithSomeFinalFieldsIsManaged() {
        long version = this.stm.getVersion();
        SomeFinalFields o = new SomeFinalFields(10, 20);
        Assert.assertTrue((boolean)(o instanceof AlphaTransactionalObject));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)o.getFinalValue());
        Assert.assertEquals((long)10L, (long)o.finalValue);
        Assert.assertEquals((long)20L, (long)o.getNonFinalValue());
    }

    @Test
    public void txObjectWithAllFinalFieldsIsNotManaged() {
        long version = this.stm.getVersion();
        AllFinalFields o = new AllFinalFields(10, 20, 30);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)o.getValue1());
        Assert.assertEquals((long)20L, (long)o.getValue2());
        Assert.assertEquals((long)30L, (long)o.getValue3());
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
    }

    @Test
    public void testChainedReferences() {
        ChainedRef ref1 = new ChainedRef(null, 1);
        ChainedRef ref2 = new ChainedRef(ref1, 2);
        ChainedRef ref3 = new ChainedRef(ref2, 3);
        Assert.assertSame((Object)ref2, (Object)ref3.getNext());
        Assert.assertSame((Object)ref1, (Object)ref3.getIndirectNext());
        Assert.assertNull((Object)ref3.getLongIndirectNext());
        Assert.assertSame((Object)ref1, (Object)ref2.getNext());
        Assert.assertNull((Object)ref2.getIndirectNext());
    }

    @TransactionalObject
    public static class ChainedRef {
        int someValue;
        final ChainedRef next;

        public ChainedRef(ChainedRef next, int someValue) {
            this.next = next;
            this.someValue = someValue;
        }

        public ChainedRef getNext() {
            return this.next;
        }

        public int getSomeValue() {
            return this.someValue;
        }

        public ChainedRef getIndirectNext() {
            return this.next.next;
        }

        public ChainedRef getLongIndirectNext() {
            return this.next.next.next;
        }
    }

    @TransactionalObject
    public static class AllFinalFields {
        final int value1;
        final int value2;
        final int value3;

        public AllFinalFields(int value1, int value2, int value3) {
            this.value1 = value1;
            this.value2 = value2;
            this.value3 = value3;
        }

        public int getValue1() {
            return this.value1;
        }

        public int getValue2() {
            return this.value2;
        }

        public int getValue3() {
            return this.value3;
        }
    }

    @TransactionalObject
    public static class SomeFinalFields {
        private final int finalValue;
        private int nonFinalValue;

        public SomeFinalFields(int finalValue, int nonFinalValue) {
            this.finalValue = finalValue;
            this.nonFinalValue = nonFinalValue;
        }

        public int getFinalValue() {
            return this.finalValue;
        }

        public int getNonFinalValue() {
            return this.nonFinalValue;
        }
    }

    @TransactionalObject
    public static class OneFinalField {
        final int value;

        public OneFinalField(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    @TransactionalObject
    public static class NoFields {
    }
}

