/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.integrationtest;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.instrumentation.InstrumentationTestUtils;
import org.multiverse.javaagent.JavaAgentProblemMonitor;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.instrumentation.AlphaReflectionUtils;
import org.multiverse.stms.alpha.instrumentation.integrationtest.Queue;

public class QueueTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        Assert.assertFalse((boolean)JavaAgentProblemMonitor.INSTANCE.isProblemFound());
    }

    @Test
    public void testStructuralContent() {
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsField(Queue.class, "pushedStack"));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsField(Queue.class, "readyToPopStack"));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsField(Queue.class, "maxCapacity"));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsTranlocalClass(Queue.class));
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsTranlocalSnapshotClass(Queue.class));
    }

    @Test
    public void testIsNotTransformedToAlphaTransactionalObject() {
        Queue queue = new Queue();
        Assert.assertFalse((boolean)(queue instanceof AlphaTransactionalObject));
    }

    @Test
    public void testConstruction() {
        long version = this.stm.getVersion();
        Queue queue = new Queue(100);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    public void complexScenario() {
        Queue<String> queue = new Queue<String>(100);
        queue.push("1");
        queue.push("2");
        Assert.assertEquals((Object)"1", queue.take());
        queue.push("3");
        Assert.assertEquals((Object)"2", queue.take());
        Assert.assertEquals((Object)"3", queue.take());
    }

    @Test
    public void testRollback() {
        Queue<String> queue = new Queue<String>();
        long version = this.stm.getVersion();
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build();
        Transaction tx = txFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        queue.push("foo");
        queue.push("bar");
        tx.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertTrue((boolean)queue.isEmpty());
    }
}

