/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.integrationtest;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;
import org.multiverse.stms.alpha.instrumentation.integrationtest.Node;

@TransactionalObject
public final class Stack<E> {
    private int size = 0;
    private Node<E> head = null;

    public void clear() {
        this.size = 0;
        this.head = null;
    }

    public void push(E item) {
        if (item == null) {
            throw new NullPointerException();
        }
        this.head = new Node<E>(this.head, item);
        this.incSize(1);
    }

    public E pop() {
        if (this.size() == 0) {
            StmUtils.retry();
        }
        this.incSize(-1);
        Node<E> oldHead = this.head;
        this.head = oldHead.next;
        return oldHead.value;
    }

    private void incSize(int amount) {
        this.size += amount;
    }

    @TransactionalMethod(readonly=true)
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @TransactionalMethod(readonly=true)
    public int size() {
        return this.size;
    }
}

