/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.transactionalmethod;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.instrumentation.AlphaReflectionUtils;

public class TransactionalMethod_BasicTransactionalObjectMixinTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        Class<SomeTxObject> clazz = SomeTxObject.class;
        Assert.assertEquals(Object.class, clazz.getSuperclass());
        this.assertAllInstanceFieldsAreCopied(clazz);
        this.assertAllStaticFieldsAreCopied(clazz);
        this.assertAlphaAtomicObjectInterfaceIsCopied(clazz);
    }

    private void assertAllStaticFieldsAreCopied(Class clazz) {
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsField(clazz, "___LOCKOWNER_UPDATER"));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsField(clazz, "___LISTENERS_UPDATER"));
    }

    private void assertAlphaAtomicObjectInterfaceIsCopied(Class clazz) {
        Assert.assertTrue((boolean)this.hasInterface(clazz, AlphaTransactionalObject.class));
    }

    private boolean hasInterface(Class clazz, Class theInterface) {
        for (Class<?> anInterface : clazz.getInterfaces()) {
            if (!anInterface.equals(theInterface)) continue;
            return true;
        }
        return false;
    }

    private void assertAllInstanceFieldsAreCopied(Class clazz) {
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsField(clazz, "___lockOwner"));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsField(clazz, "___tranlocal"));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsField(clazz, "___listeners"));
    }

    @TransactionalObject
    public static class SomeTxObject {
        int x;

        SomeTxObject(int x) {
            this.x = x;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }
    }
}

