/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.transactionalmethod;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;

public class TransactionalMethod_ReadonlyUpdateTransactionTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void instanceReadonlyMethod() {
        long version = this.stm.getVersion();
        InstanceReadonlyMethod method = new InstanceReadonlyMethod();
        method.execute();
        AlphaTransaction transaction = method.transaction;
        System.out.println("transaction.class: " + transaction.getClass());
        Assert.assertTrue((boolean)(transaction instanceof NonTrackingReadonlyAlphaTransaction));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((long)0L, (long)method.version);
    }

    @Test
    public void staticReadonlyMethod() {
        long version = this.stm.getVersion();
        StaticReadonlyMethod.execute();
        AlphaTransaction transaction = StaticReadonlyMethod.transaction;
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((long)0L, (long)StaticReadonlyMethod.version);
        Assert.assertTrue((boolean)(transaction instanceof NonTrackingReadonlyAlphaTransaction));
    }

    static class StaticReadonlyMethod {
        static AlphaTransaction transaction;
        static long version;

        StaticReadonlyMethod() {
        }

        @TransactionalMethod(readonly=true)
        public static void execute() {
            transaction = (AlphaTransaction)ThreadLocalTransaction.getThreadLocalTransaction();
            version = transaction.getReadVersion();
        }
    }

    static class InstanceReadonlyMethod {
        AlphaTransaction transaction;
        long version;

        InstanceReadonlyMethod() {
        }

        @TransactionalMethod(readonly=true)
        public void execute() {
            this.transaction = (AlphaTransaction)ThreadLocalTransaction.getThreadLocalTransaction();
            this.version = this.transaction.getReadVersion();
        }
    }
}

