/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.transactionalmethod;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class TransactionalMethod_settingTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void retryCount() {
        ObjectWithRetryCount o = new ObjectWithRetryCount();
        AtomicInteger tryCounter = new AtomicInteger();
        try {
            o.doSomething(tryCounter);
            Assert.fail();
        }
        catch (TooManyRetriesException tooManyRetriesException) {
            // empty catch block
        }
        Assert.assertEquals((long)52L, (long)tryCounter.get());
    }

    @Test
    public void testAllowWriteSkew() {
        ObjectWithPreventWriteSkew object = new ObjectWithPreventWriteSkew();
        Assert.assertFalse((boolean)object.updateWithDisallowedWriteSkew());
        Assert.assertTrue((boolean)object.updateDefaultMethod());
        Assert.assertTrue((boolean)object.updateWithAllowedWriteSkew());
        Assert.assertFalse((boolean)object.updateWithDisallowedWriteSkewAndDefaultAutomaticReadTracking());
    }

    @Test
    public void testReadonly() {
        ObjectWithReadonly o = new ObjectWithReadonly();
        o.defaultMethod();
        o.explicitReadonlyMethod();
        o.explicitUpdateMethod();
    }

    @Test
    public void testInterruptible() throws InterruptedException {
        ObjectWithInterruptible o = new ObjectWithInterruptible();
        o.defaultMethodIsNotInterruptible();
        o.defaultMethodWithEmptyTransactionalMethodIsNotInterruptible();
        o.withInterruptibleSet();
        o.withNoTransactionalMethodButThrowingInterruptibleException();
        o.withEmptyTransactionalMethodException();
    }

    @Test
    public void automaticReadTracking() {
        AutomaticReadTracking m = new AutomaticReadTracking();
        m.defaultMethod();
        m.readonlyMethod();
        m.readonlyMethodWithReadTrackingDisabled();
        m.readonlyMethodWithReadTrackingEnabled();
        m.defaultUpdateMethod();
        m.updateMethodWithReadTrackingDisabled();
        m.updateMethodWithReadTrackingEnabled();
    }

    @Test
    public void whenLogLevel() {
        LogLevelObject o = new LogLevelObject();
        o.explicitValueCourse();
        o.explicitValueFine();
        o.explicitValueNone();
        o.defaultValue();
    }

    class LogLevelObject {
        LogLevelObject() {
        }

        @TransactionalMethod(traceLevel=TraceLevel.course)
        void explicitValueCourse() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertEquals((Object)TraceLevel.course, (Object)tx.getConfiguration().getTraceLevel());
        }

        @TransactionalMethod(traceLevel=TraceLevel.fine)
        void explicitValueFine() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertEquals((Object)TraceLevel.fine, (Object)tx.getConfiguration().getTraceLevel());
        }

        @TransactionalMethod(traceLevel=TraceLevel.none)
        void explicitValueNone() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertEquals((Object)TraceLevel.none, (Object)tx.getConfiguration().getTraceLevel());
        }

        @TransactionalMethod
        void defaultValue() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertEquals((Object)TraceLevel.none, (Object)tx.getConfiguration().getTraceLevel());
        }
    }

    @TransactionalObject
    public static class AutomaticReadTracking {
        private int value;

        public void defaultMethod() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertFalse((boolean)tx.getConfiguration().isReadTrackingEnabled());
        }

        @TransactionalMethod(readonly=true)
        public void readonlyMethod() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertFalse((boolean)tx.getConfiguration().isReadTrackingEnabled());
        }

        @TransactionalMethod(readonly=true, trackReads=false)
        public void readonlyMethodWithReadTrackingDisabled() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertFalse((boolean)tx.getConfiguration().isReadTrackingEnabled());
        }

        @TransactionalMethod(readonly=true, trackReads=true)
        public void readonlyMethodWithReadTrackingEnabled() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)tx.getConfiguration().isReadTrackingEnabled());
        }

        @TransactionalMethod(readonly=false)
        public void defaultUpdateMethod() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            UpdateConfiguration config = (UpdateConfiguration)tx.getConfiguration();
            System.out.println(config.speculativeConfiguration);
            TestUtils.assertInstanceOf((Object)tx, MonoUpdateAlphaTransaction.class);
            Assert.assertFalse((boolean)tx.getConfiguration().isReadTrackingEnabled());
        }

        @TransactionalMethod(readonly=false, trackReads=false)
        public void updateMethodWithReadTrackingDisabled() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertFalse((boolean)tx.getConfiguration().isReadTrackingEnabled());
        }

        @TransactionalMethod(readonly=false, trackReads=true)
        public void updateMethodWithReadTrackingEnabled() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)tx.getConfiguration().isReadTrackingEnabled());
        }
    }

    @TransactionalObject
    public static class ObjectWithInterruptible {
        private int value = 0;

        public void defaultMethodIsNotInterruptible() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertFalse((boolean)tx.getConfiguration().isInterruptible());
        }

        @TransactionalMethod
        public void defaultMethodWithEmptyTransactionalMethodIsNotInterruptible() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertFalse((boolean)tx.getConfiguration().isInterruptible());
        }

        @TransactionalMethod(interruptible=true)
        public void withInterruptibleSet() throws InterruptedException {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)tx.getConfiguration().isInterruptible());
        }

        @TransactionalMethod
        public void withEmptyTransactionalMethodException() throws InterruptedException {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)tx.getConfiguration().isInterruptible());
        }

        public void withNoTransactionalMethodButThrowingInterruptibleException() throws InterruptedException {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)tx.getConfiguration().isInterruptible());
        }
    }

    @TransactionalObject
    public static class ObjectWithReadonly {
        private int x = 0;

        public void defaultMethod() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)tx.getConfiguration().isReadonly());
        }

        @TransactionalMethod(readonly=true)
        public void explicitReadonlyMethod() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)tx.getConfiguration().isReadonly());
        }

        @TransactionalMethod(readonly=false)
        public void explicitUpdateMethod() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertFalse((boolean)tx.getConfiguration().isReadonly());
        }
    }

    @TransactionalObject
    public static class ObjectWithPreventWriteSkew {
        private int x = 0;

        @TransactionalMethod(readonly=false, writeSkew=true)
        public boolean updateWithAllowedWriteSkew() {
            int b = this.x;
            return ThreadLocalTransaction.getThreadLocalTransaction().getConfiguration().isWriteSkewAllowed();
        }

        @TransactionalMethod(readonly=false, writeSkew=false, trackReads=true)
        public boolean updateWithDisallowedWriteSkew() {
            int b = this.x;
            return ThreadLocalTransaction.getThreadLocalTransaction().getConfiguration().isWriteSkewAllowed();
        }

        @TransactionalMethod(readonly=false, writeSkew=false)
        public boolean updateWithDisallowedWriteSkewAndDefaultAutomaticReadTracking() {
            Assert.assertTrue((boolean)ThreadLocalTransaction.getThreadLocalTransaction().getConfiguration().isReadTrackingEnabled());
            int b = this.x;
            return ThreadLocalTransaction.getThreadLocalTransaction().getConfiguration().isWriteSkewAllowed();
        }

        @TransactionalMethod(readonly=false)
        public boolean updateDefaultMethod() {
            int b = this.x;
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            return ThreadLocalTransaction.getThreadLocalTransaction().getConfiguration().isWriteSkewAllowed();
        }
    }

    @TransactionalObject
    public static class ObjectWithRetryCount {
        private int x = 0;

        @TransactionalMethod(maxRetries=51)
        public void doSomething(AtomicInteger tryCounter) {
            int b = this.x;
            tryCounter.incrementAndGet();
            throw new OldVersionNotFoundReadConflict();
        }
    }
}

