/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.programmatic.ProgrammaticLongRef;
import org.multiverse.api.programmatic.ProgrammaticRefFactory;
import org.multiverse.stms.alpha.AlphaStm;

public class AlphaProgrammaticLongRef_atomicBehaviorStressTest {
    private volatile boolean stop;
    private int modifyThreadCount = 10;
    private int refCount = 100;
    private ProgrammaticLongRef[] refs;
    private AlphaStm stm;
    private ProgrammaticRefFactory refFactory;

    @Before
    public void setUp() {
        this.stop = false;
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.refFactory = this.stm.getProgrammaticRefFactoryBuilder().build();
        this.refs = new ProgrammaticLongRef[this.refCount];
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k] = this.refFactory.atomicCreateLongRef(0L);
        }
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test_withExplicitAborts() {
        this.test(true);
    }

    @Test
    public void test_withNoExplicitAborts() {
        this.test(false);
    }

    public void test(boolean withAborts) {
        TestThread[] modifyThreads = new ModifyThread[this.modifyThreadCount];
        for (int k = 0; k < this.modifyThreadCount; ++k) {
            modifyThreads[k] = new ModifyThread(k, withAborts);
        }
        TestUtils.startAll((TestThread[])modifyThreads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)10000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])modifyThreads);
        Assert.assertEquals((long)this.sumThreads((ModifyThread[])modifyThreads), (long)this.sumRefs());
    }

    public long sumRefs() {
        long result = 0L;
        for (ProgrammaticLongRef ref : this.refs) {
            result += ref.atomicGet();
        }
        return result;
    }

    public long sumThreads(ModifyThread[] threads) {
        long result = 0L;
        for (ModifyThread thread : threads) {
            result += thread.incCount;
        }
        return result;
    }

    public class ModifyThread
    extends TestThread {
        private final boolean withAborts;
        private long incCount;

        public ModifyThread(int id, boolean withAborts) {
            super("ModifyThread-" + id);
            this.withAborts = withAborts;
        }

        public void doRun() throws Exception {
            long k = 0L;
            while (!AlphaProgrammaticLongRef_atomicBehaviorStressTest.this.stop) {
                boolean abort;
                if (k % 100000L == 0L) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                boolean bl = abort = this.withAborts && k % 2L == 0L;
                if (abort) {
                    try {
                        this.incRefsButAbort();
                        Assert.fail();
                    }
                    catch (DeadTransactionException ignore) {}
                } else {
                    this.incCount += this.incRefs();
                }
                ++k;
            }
        }

        @TransactionalMethod
        private long incRefs() {
            return this.modifyInternal();
        }

        @TransactionalMethod
        private long incRefsButAbort() {
            this.modifyInternal();
            ThreadLocalTransaction.getThreadLocalTransaction().abort();
            return 0L;
        }

        private long modifyInternal() {
            long incCount = 0L;
            for (ProgrammaticLongRef ref : AlphaProgrammaticLongRef_atomicBehaviorStressTest.this.refs) {
                if (!TestUtils.randomOneOf((int)10)) continue;
                ref.inc(1L);
                ++incCount;
            }
            return incCount;
        }
    }
}

